﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

class Win32HidInterface
{
    NN_DISALLOW_COPY(Win32HidInterface);
    NN_DISALLOW_MOVE(Win32HidInterface);

public:

    Win32HidInterface() NN_NOEXCEPT{};
    ~Win32HidInterface() NN_NOEXCEPT{};

    Result Initialize(uint16_t index) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    Result IncHandleSemaphore(uint32_t handle) NN_NOEXCEPT;
    Result DecHandleSemaphore() NN_NOEXCEPT;

    Result ClientAcquireDevice(uint32_t handle) NN_NOEXCEPT;
    Result ClientReleaseDevice(uint32_t handle) NN_NOEXCEPT;
    Result EnumAttachDevice(nn::ahid::hdr::Hdr* pHdr, nn::ahid::hdr::DeviceParameters* pHdrDeviceParameters) NN_NOEXCEPT;
    Result EnumDetachDevice(nn::ahid::hdr::Hdr* pHdr) NN_NOEXCEPT;
    Result SetCtrlSession(nn::sf::SharedPointer<nn::ahid::ICtrlSession> pCtrlSession) NN_NOEXCEPT;

    void SetDevInst(DWORD devInst) NN_NOEXCEPT;
    DWORD GetDevInst() NN_NOEXCEPT;
    void SetIsAttached(bool isAttached) NN_NOEXCEPT;
    bool GetIsAttached() NN_NOEXCEPT;
    void SetWin32Handle(HANDLE handle) NN_NOEXCEPT;
    HANDLE GetWin32Handle() NN_NOEXCEPT;

private:

    uint16_t                        m_HandleIndex;
    uint16_t                        m_HandleInstance;
    bool                            m_IsOccupied;
    bool                            m_IsAcquired;
    bool                            m_IsAttached;
    nn::ahid::hdr::DeviceHandle     m_HdrDeviceHandle;
    DWORD                           m_DevInst;
    HANDLE                          m_Win32Handle;

    nn::sf::SharedPointer<nn::ahid::ICtrlSession>  m_CtrlSession;

    void ChangeHandle() NN_NOEXCEPT;
};

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
