﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace usb {

class UsbHidServer : public nn::sf::HipcSimpleAllInOneServerManager<USBHID_SERVER_MAX_SESSIONS, 1>
{
    NN_DISALLOW_COPY(UsbHidServer);
    NN_DISALLOW_MOVE(UsbHidServer);

public:

    UsbHidServer() NN_NOEXCEPT{};
    ~UsbHidServer() NN_NOEXCEPT{};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::ahid::IServerSession> GetDfcSession() NN_NOEXCEPT;

private:

    UsbHidEnum                              m_Enum;

    // Heap
    uint8_t                                 m_SfHeapBuffer[4096]; // reduced from 16K
    nn::lmem::HeapHandle                    m_HeapHandle;
    nn::sf::ExpHeapAllocator                m_SfAllocator;

    // Thread
    NN_ALIGNAS(4096) uint8_t                m_ThreadStack[USBHID_SERVER_MAX_THREADS][USBHID_SERVER_THREAD_STACK_SIZE];
    nn::os::ThreadType                      m_Thread[USBHID_SERVER_MAX_THREADS];

    nn::sf::SharedPointer<nn::ahid::IServerSession> CreateSession() NN_NOEXCEPT;
    virtual nn::Result OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT;
    static void SessionThread(void *arg) NN_NOEXCEPT;
};

} // end of namespace usb
} // end of namespace cdhid
} // end of namespace nn
