﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "cdhidUsb_Private.h"
#include "cdhidUsb_Main.h"

namespace nn {
namespace cdhid {
namespace usb {

namespace {

    UsbHidServer g_UsbHidServer;

} // end of namespace

//////////////////////////////////////////////////////////////////////////////
Result UsbHidInitialize() NN_NOEXCEPT
{
    g_UsbHidServer.Initialize();

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result UsbHidFinalize() NN_NOEXCEPT
{
    g_UsbHidServer.Finalize();

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
nn::sf::SharedPointer<nn::ahid::IServerSession> UsbHidGetDfcSession() NN_NOEXCEPT
{
    return g_UsbHidServer.GetDfcSession();
}


} // end of namespace usb
} // end of namespace cdhid
} // end of namespace nn
