﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ahid/hdr/hdr.h>

namespace nn {
namespace cdhid {
namespace usb {

enum
{
    ENUM_THREAD_STACK_SIZE  = 16 * 1024,
};

class UsbHidEnum
{
    NN_DISALLOW_COPY(UsbHidEnum);
    NN_DISALLOW_MOVE(UsbHidEnum);

public:

    UsbHidEnum() NN_NOEXCEPT{};
    ~UsbHidEnum() NN_NOEXCEPT{};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    Result AcquireDevice(uint32_t deviceHandle, UsbHidInterface **ppUsbHidInterface) NN_NOEXCEPT;
    Result ReleaseDevice(uint32_t deviceHandle) NN_NOEXCEPT;

private:

    bool                            m_Continue;

    nn::os::MultiWaitType           m_MultiWait;
    nn::os::MultiWaitHolderType     m_MultiWaitHolderTeardown;
    nn::os::MultiWaitHolderType     m_MultiWaitHolderAttach;
    nn::os::MultiWaitHolderType     m_MultiWaitHolderDetach;
    nn::os::EventType               m_TeardownEvent;
    nn::os::SystemEvent             m_AttachEvent;
    nn::os::SystemEventType*        m_pDetachEvent;

    nn::ahid::hdr::Hdr              m_Hdr;
    nn::usb::Host                   m_UsbHs;
    UsbHidInterface                 m_UsbHidInterface[USBHID_SERVER_MAX_NUM_DEVICES];

    nn::os::ThreadType              m_Thread;
    NN_ALIGNAS(4096) uint8_t        m_ThreadStack[ENUM_THREAD_STACK_SIZE];
    NN_ALIGNAS(4096) uint8_t        m_TransactionBuffer[4096];

    static void EnumThread(void *arg) NN_NOEXCEPT;

    void ProcessAttach(nn::usb::InterfaceQueryOutput* pProfile, int32_t ifCount) NN_NOEXCEPT;
    void ProcessDetach(nn::usb::InterfaceQueryOutput* pProfile, int32_t ifCount) NN_NOEXCEPT;

    Result GetInterfaceIndex(int deviceHandle, int *pIndex) NN_NOEXCEPT;
};

} // end of namespace usb
} // end of namespace cdhid
} // end of namespace nn
