﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.bluetooth
{
    [CppRefPath(@"<nn/bluetooth/bluetooth_LeTypes.h>")]
    [ExternalStruct(20, 4)]
    public struct GattAttributeUuid
    {
    }
}

namespace nn.btm
{

//[Todo]enum,boolを固定長の型にする
//[Todo]必要に応じて、SF専用構造体に置き換える

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(6, 1)]
    public struct BdAddress
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(42, 1)]
    public struct HostDeviceProperty
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(616, 1)]
    [LargeData(true)]
    public struct DevicePropertyList
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(96, 4)]
    public struct DeviceInfo
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(964, 4)]
    [LargeData(true)]
    public struct DeviceInfoList
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(880, 4)]
    [LargeData(true)]
    public struct DeviceConditionList
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [LargeData(true)]
    [ExternalStruct(17, 1)]
    public struct ZeroRetransmissionList
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [LargeData(true)]
    [ExternalStruct(17, 1)]
    public struct GeneralInfoList
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [LargeData(true)]
    [ExternalStruct(100, 4)]
    public struct DeviceSlotModeList
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct TotalSlotSize
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct TsiMode
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct BtmState
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct Profile
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct DeviceCountMax
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct BluetoothMode
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct WlanMode
    {
    }

    [CppRefPath(@"<nn/btm/btm_Types.h>")]
    [LargeData(true)]
    [ExternalStruct(116, 4)]
    public struct GattClientConditionList
    {
    }

    namespace user
    {
        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [ExternalStruct(8, 1)]
        public struct BleAdvFilterForGeneral
        {
        }

        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [ExternalStruct(20, 4)]
        public struct BleAdvFilterForSmartDevice
        {
        }

        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [LargeData(true)]
        [ExternalStruct(328, 4)]
        public struct ScanResult
        {
        }

        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [ExternalStruct(12, 4)]
        public struct BleClientConnState
        {
        }

        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [LargeData(true)]
        [ExternalStruct(36, 4)]
        public struct GattService
        {
        }

        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [LargeData(true)]
        [ExternalStruct(36, 4)]
        public struct GattCharacteristic
        {
        }

        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [LargeData(true)]
        [ExternalStruct(32, 4)]
        public struct GattDescriptor
        {
        }

        [CppRefPath(@"<nn/btm/user/btm_UserTypes.h>")]
        [ExternalStruct(24, 4)]
        public struct BleDataPath
        {
        }
    }

    [CppRefPath(@"<nn/btm/btm_IBtm.sfdl.h>")]
    public interface IBtm : IServiceObject
    {
        [MethodId(0)]
        void GetStateImpl(Out<BtmState> pState);
        [MethodId(1)]
        void GetHostDevicePropertyImpl(Out<HostDeviceProperty> pHostDeviceProperty);

        [MethodId(2)]
        bool AcquireDeviceConditionEventImpl(Out<NativeHandle> handle);
        [MethodId(3)]
        void GetDeviceConditionImpl(Out<DeviceConditionList> pList);
        [MethodId(4)]
        Result SetBurstModeImpl(BdAddress bdAddress, bool isBurstMode);
        [MethodId(5)]
        Result SetSlotModeImpl(DeviceSlotModeList deviceSlotModeList);
        [MethodId(6)]
        Result SetBluetoothModeImpl(BluetoothMode bluetoothMode);
        [MethodId(7)]
        Result SetWlanModeImpl(WlanMode wlanMode);

        [MethodId(8)]
        bool AcquireDeviceInfoEventImpl(Out<NativeHandle> handle);
        [MethodId(9)]
        void GetDeviceInfoImpl(Out<DeviceInfoList> pList);
        [MethodId(10)]
        void AddDeviceInfoImpl(DeviceInfo info);
        [MethodId(11)]
        void RemoveDeviceInfoImpl(BdAddress address);
        [MethodId(12)]
        void IncreaseDeviceInfoOrderImpl(BdAddress address);
        [MethodId(13)]
        Result LlrNotifyImpl(BdAddress address);
        [MethodId(14)]
        void EnableRadioImpl();
        [MethodId(15)]
        void DisableRadioImpl();


        [MethodId(16)]
        void HidDisconnectImpl(BdAddress bdAddress);
        [MethodId(17)]
        Result HidSetRetransmissionModeImpl(BdAddress bdAddress, ZeroRetransmissionList zeroRetransmissionList);

        [MethodId(18)]
        bool AcquireAwakeReqEventImpl(Out<NativeHandle> handle);

        [MethodId(19)]
        bool AcquireLlrStateEventImpl(Out<NativeHandle> handle);
        [MethodId(20)]
        bool IsLlrStartedImpl();
        [MethodId(21)]
        void EnableSlotSavingImpl(bool isEnable);

        [MethodId(22)]
        void ProtectDeviceInfoImpl(BdAddress address, bool isProtect);

        [MethodId(23)]
        bool AcquireBleScanEventImpl(Out<NativeHandle> handle);
        [MethodId(24)]
        Result GetBleScanParameterGeneralImpl(Out<user.BleAdvFilterForGeneral> pFilter, uint16_t parameterId);
        [MethodId(25)]
        Result GetBleScanParameterSmartDeviceImpl(Out<user.BleAdvFilterForSmartDevice> pFilter, uint16_t parameterId);
        [MethodId(26)]
        Result StartBleScanForGeneralImpl(user.BleAdvFilterForGeneral filter);
        [MethodId(27)]
        Result StopBleScanForGeneralImpl();
        [MethodId(28)]
        void GetBleScanResultsForGeneralImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.ScanResult> pResult, Out<uint8_t> pOutNum);
        [MethodId(29)]
        Result StartBleScanForPairedDeviceImpl(user.BleAdvFilterForGeneral filter);
        [MethodId(30)]
        Result StopBleScanForPairedDeviceImpl();
        [MethodId(31)]
        Result StartBleScanForSmartDeviceImpl(user.BleAdvFilterForSmartDevice filter);
        [MethodId(32)]
        Result StopBleScanForSmartDeviceImpl();
        [MethodId(33)]
        void GetBleScanResultsForSmartDeviceImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.ScanResult> pResult, Out<uint8_t> pOutNum);
        [MethodId(34)]
        bool AcquireBleConnectionEventImpl(Out<NativeHandle> handle);
        [MethodId(35)]
        Result BleConnectImpl(BdAddress bdAddress);
        [MethodId(36)]
        Result BleOverrideConnectionImpl(uint32_t connectionHandle);
        [MethodId(37)]
        Result BleDisconnectImpl(uint32_t connectionHandle);
        [MethodId(38)]
        void BleGetConnectionStateImpl(OutArray<user.BleClientConnState> pConnState, Out<uint8_t> pOutNum);
        [MethodId(39)]
        void BleGetGattClientConditionListImpl(Out<GattClientConditionList> pGattClientConditionList);
        [MethodId(40)]
        bool AcquireBlePairingEventImpl(Out<NativeHandle> handle);
        [MethodId(41)]
        Result BlePairDeviceImpl(uint32_t connectionHandle, user.BleAdvFilterForGeneral filter);
        [MethodId(42)]
        Result BleUnpairDeviceOnBothImpl(uint32_t connectionHandle, user.BleAdvFilterForGeneral filter);
        [MethodId(43)]
        Result BleUnpairDeviceImpl(BdAddress bdAddress, user.BleAdvFilterForGeneral filter);
        [MethodId(44)]
        void BleGetPairedAddressesImpl(OutArray<BdAddress> pAddresses, Out<uint8_t> pOutNum, user.BleAdvFilterForGeneral filter);
        [MethodId(45)]
        bool AcquireBleServiceDiscoveryEventImpl(Out<NativeHandle> handle);
        [MethodId(46)]
        void GetGattServicesImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattService> pServices, Out<uint8_t> pOutNum, uint32_t connectionHandle);
        [MethodId(47)]
        bool GetGattServiceImpl(Out<user.GattService> pService, uint32_t connectionHandle, nn.bluetooth.GattAttributeUuid uuid);
        [MethodId(48)]
        void GetGattIncludedServicesImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattService> pIncludedServices, Out<uint8_t> pOutNum,
                                         uint32_t connectionHandle, uint16_t serviceHandle);
        [MethodId(49)]
        bool GetBelongingServiceImpl(Out<user.GattService> pService, uint32_t connectionHandle, uint16_t attributeHandle);

        [MethodId(50)]
        void GetGattCharacteristicsImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattCharacteristic> pCharacteristics, Out<uint8_t> pOutNum, uint32_t connectionHandle, uint16_t serviceHandle);
        [MethodId(51)]
        void GetGattDescriptorsImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattDescriptor> pDescriptors, Out<uint8_t> pOutNum, uint32_t connectionHandle, uint16_t charHandle);
        [MethodId(52)]
        bool AcquireBleMtuConfigEventImpl(Out<NativeHandle> handle);
        [MethodId(53)]
        Result ConfigureBleMtuImpl(uint32_t connectionHandle, uint16_t mtu);
        [MethodId(54)]
        void GetBleMtuImpl(Out<uint16_t> mtu, uint32_t connectionHandle);
        [MethodId(55)]
        Result RegisterBleGattDataPathImpl(user.BleDataPath path);
        [MethodId(56)]
        Result UnregisterBleGattDataPathImpl(user.BleDataPath path);
        [MethodId(57)]
        Result RegisterAppletResourceUserIdImpl(nn.applet.AppletResourceUserId aruid, uint32_t appletId);
        [MethodId(58)]
        Result UnregisterAppletResourceUserIdImpl(nn.applet.AppletResourceUserId aruid);
        [MethodId(59)]
        Result SetAppletResourceUserIdImpl(nn.applet.AppletResourceUserId aruid);

    }

    [CppRefPath(@"<nn/btm/btm_IBtm.sfdl.h>")]
    public interface IBtmSystem : IServiceObject
    {
        [MethodId(0)]
        void GetCoreImpl(Out<IBtmSystemCore> pOutService);
    }

    [CppRefPath(@"<nn/btm/btm_IBtm.sfdl.h>")]
    public interface IBtmSystemCore : IServiceObject
    {
        [MethodId(0)]
        Result StartGamepadPairingImpl();
        [MethodId(1)]
        void CancelGamepadPairingImpl();
        [MethodId(2)]
        void ClearGamepadPairingDatabaseImpl();
        [MethodId(3)]
        void GetPairedGamepadCountImpl(Out<uint8_t> pPairedGamepadCount);
        [MethodId(4)]
        void EnableRadioImpl();
        [MethodId(5)]
        void DisableRadioImpl();
        [MethodId(6)]
        void GetRadioOnOffImpl(Out<bool> pIsRadioOn);
        [MethodId(7)]
        bool AcquireRadioEventImpl(Out<NativeHandle> handle);
        [MethodId(8)]
        bool AcquireGamepadPairingEventImpl(Out<NativeHandle> handle);
        [MethodId(9)]
        bool IsGamepadPairingStartedImpl();
    }

    [CppRefPath(@"<nn/btm/btm_IBtm.sfdl.h>")]
    public interface IBtmDebug : IServiceObject
    {
        [MethodId(0)]
        bool AcquireDiscoveryEventImpl(Out<NativeHandle> handle);
        [MethodId(1)]
        Result StartDiscoveryImpl();
        [MethodId(2)]
        Result CancelDiscoveryImpl();
        [MethodId(3)]
        void GetDevicePropertyImpl(Out<DevicePropertyList> pList);

        [MethodId(4)]
        Result CreateBondImpl(BdAddress bdAddress);
        [MethodId(5)]
        Result CancelBondImpl(BdAddress bdAddress);

        [MethodId(6)]
        Result SetTsiModeImpl(BdAddress bdAddress, TsiMode tsiMode);
        [MethodId(7)]
        void GeneralTestImpl(int mode);

        [MethodId(8)]
        void HidConnectImpl(BdAddress bdAddress);
        [MethodId(9)]
        void GeneralGetImpl(int mode, Out<GeneralInfoList> pList);

        [MethodId(10)]
        bool GetGattClientDisconnectionReasonImpl(Out<uint16_t> pOutReason, uint32_t connectionHandle, BdAddress address);
        [MethodId(11)]
        bool GetBleConnectionParameterImpl(Out<uint16_t> pOutInterval, Out<uint16_t> pOutLatency, Out<uint16_t> pOutTimeout,
                                           uint32_t connectionHandle);
        [MethodId(12)]
        bool GetBleConnectionParameterRequestImpl(Out<uint16_t> pOutIntervalMin, Out<uint16_t> pOutIntervalMax, Out<uint16_t> pOutLatency, Out<uint16_t> pOutTimeout,
                                                  uint32_t connectionHandle);
    }

    [CppRefPath(@"<nn/btm/btm_IBtm.sfdl.h>")]
    public interface IBtmUser : IServiceObject
    {
        [MethodId(0)]
        void GetCoreImpl(Out<IBtmUserCore> pOutService);
    }

    [CppRefPath(@"<nn/btm/btm_IBtm.sfdl.h>")]
    public interface IBtmUserCore : IServiceObject
    {
        [MethodId(0)]
        bool AcquireBleScanEventImpl(Out<NativeHandle> handle);
        [MethodId(1)]
        Result GetBleScanParameterGeneralImpl(Out<user.BleAdvFilterForGeneral> pFilter, uint16_t parameterId);
        [MethodId(2)]
        Result GetBleScanParameterSmartDeviceImpl(Out<user.BleAdvFilterForSmartDevice> pFilter, uint16_t parameterId);
        [MethodId(3)]
        Result StartBleScanForGeneralImpl(nn.applet.CheckedAppletResourceUserId aruid, user.BleAdvFilterForGeneral filter);
        [MethodId(4)]
        Result StopBleScanForGeneralImpl();
        [MethodId(5)]
        void GetBleScanResultsForGeneralImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.ScanResult> pResult, Out<uint8_t> pOutNum,
                                             nn.applet.CheckedAppletResourceUserId aruid);
        [MethodId(6)]
        Result StartBleScanForPairedDeviceImpl(nn.applet.CheckedAppletResourceUserId aruid, user.BleAdvFilterForGeneral filter);
        [MethodId(7)]
        Result StopBleScanForPairedDeviceImpl();
        [MethodId(8)]
        Result StartBleScanForSmartDeviceImpl(nn.applet.CheckedAppletResourceUserId aruid, user.BleAdvFilterForSmartDevice filter);
        [MethodId(9)]
        Result StopBleScanForSmartDeviceImpl();
        [MethodId(10)]
        void GetBleScanResultsForSmartDeviceImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.ScanResult> pResult, Out<uint8_t> pOutNum,
                                                 nn.applet.CheckedAppletResourceUserId aruid);
//        [MethodId(11)]
//        Result RegisterBleStreetPassImpl(user.BleAdvFilterForGeneral filter);
//        [MethodId(12)]
//        void UnregisterBleStreetPassImpl(user.BleAdvFilterForGeneral filter);
//        [MethodId(13)]
//        void GetBleStreetPassResultsImpl(OutArray<user.ScanResult> pResult, Out<uint8_t> pOutNum, user.BleAdvFilterForGeneral filter);
//        [MethodId(14)]
//        Result RegisterBleSmartDeviceStreetPassImpl(user.BleAdvFilterForSmartDevice filter);
//        [MethodId(15)]
//        void UnregisterBleSmartDeviceStreetPassImpl(user.BleAdvFilterForSmartDevice filter);
//        [MethodId(16)]
//        void GetBleSmartDeviceStreetPassResultsImpl(OutArray<user.ScanResult> pResult, Out<uint8_t> pOutNum, user.BleAdvFilterForSmartDevice filter);
        [MethodId(17)]
        bool AcquireBleConnectionEventImpl(Out<NativeHandle> handle);
        [MethodId(18)]
        Result BleConnectImpl(nn.applet.CheckedAppletResourceUserId aruid, BdAddress bdAddress);
        [MethodId(19)]
        Result BleDisconnectImpl(uint32_t connectionHandle);
        [MethodId(20)]
        void BleGetConnectionStateImpl(OutArray<user.BleClientConnState> pConnState, Out<uint8_t> pOutNum,
                                       nn.applet.CheckedAppletResourceUserId aruid);
        [MethodId(21)]
        bool AcquireBlePairingEventImpl(Out<NativeHandle> handle);
        [MethodId(22)]
        Result BlePairDeviceImpl(uint32_t connectionHandle, user.BleAdvFilterForGeneral filter);
        [MethodId(23)]
        Result BleUnpairDeviceOnBothImpl(uint32_t connectionHandle, user.BleAdvFilterForGeneral filter);
        [MethodId(24)]
        Result BleUnpairDeviceImpl(BdAddress bdAddress, user.BleAdvFilterForGeneral filter);
        [MethodId(25)]
        void BleGetPairedAddressesImpl(OutArray<BdAddress> pAddresses, Out<uint8_t> pOutNum, user.BleAdvFilterForGeneral filter);
        [MethodId(26)]
        bool AcquireBleServiceDiscoveryEventImpl(Out<NativeHandle> handle);
        [MethodId(27)]
        void GetGattServicesImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattService> pServices, Out<uint8_t> pOutNum,
                                 nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle);
        [MethodId(28)]
        bool GetGattServiceImpl(Out<user.GattService> pService,
                                nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle, nn.bluetooth.GattAttributeUuid uuid);
        [MethodId(29)]
        void GetGattIncludedServicesImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattService> pIncludedServices, Out<uint8_t> pOutNum,
                                         nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle, uint16_t serviceHandle);
        [MethodId(30)]
        bool GetBelongingServiceImpl(Out<user.GattService> pService,
                                     nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle, uint16_t attributeHandle);
        [MethodId(31)]
        void GetGattCharacteristicsImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattCharacteristic> pCharacteristics, Out<uint8_t> pOutNum,
                                        nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle, uint16_t serviceHandle);
        [MethodId(32)]
        void GetGattDescriptorsImpl([BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<user.GattDescriptor> pDescriptors, Out<uint8_t> pOutNum,
                                    nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle, uint16_t charHandle);
        [MethodId(33)]
        bool AcquireBleMtuConfigEventImpl(Out<NativeHandle> handle);
        [MethodId(34)]
        Result ConfigureBleMtuImpl(nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle, uint16_t mtu);
        [MethodId(35)]
        void GetBleMtuImpl(Out<uint16_t> mtu,
                           nn.applet.CheckedAppletResourceUserId aruid, uint32_t connectionHandle);
        [MethodId(36)]
        Result RegisterBleGattDataPathImpl(nn.applet.CheckedAppletResourceUserId aruid, user.BleDataPath path);
        [MethodId(37)]
        Result UnregisterBleGattDataPathImpl(nn.applet.CheckedAppletResourceUserId aruid, user.BleDataPath path);
    }
}
