﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/i2c/i2c.h>

#include "bpc_PmicAccessor-hardware.nx.h"

namespace
{
bool HasDevice(nn::i2c::I2cSession* pSession)
{
    // CID0 (シリアル) の Read によってデバイスが存在するかをチェックする
    // 値はバラバラなので値のチェックはしない
    const nn::Bit8 Cid0RegisterAddress = 0x58;
    nn::Bit8 cid;
    auto result = nn::i2c::ReadSingleRegister(&cid, *pSession, &Cid0RegisterAddress);
    return result.IsSuccess();
}
}

namespace nn { namespace bpc { namespace driver { namespace detail {

nn::i2c::I2cSession* GetPmicI2cSession() NN_NOEXCEPT
{
    static nn::i2c::I2cSession s_Session;
    static bool s_IsSessionOpen = false;
    if (!s_IsSessionOpen)
    {
        s_IsSessionOpen = true;
        // open session
        nn::i2c::Initialize();
        nn::i2c::OpenSession(&s_Session, nn::i2c::I2cDevice_Max77620Pmic);

        NN_ABORT_UNLESS(HasDevice(&s_Session));
    }
    return &s_Session;
}

}}}} // namespace nn::bpc::driver::detail
