﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

#include <nn/bpc/bpc_BoardPowerControlTypes.h>

namespace nn { namespace bpc { namespace driver { namespace detail {

void InitializeIrqHandler(nn::os::MessageQueueType* pMessageQueueOnOff) NN_NOEXCEPT;
void FinalizeIrqHandler() NN_NOEXCEPT;
void SuspendIrqHandler() NN_NOEXCEPT;
void ResumeIrqHandler() NN_NOEXCEPT;
void GetBoardPowerControlEventPtr(nn::os::SystemEventType** pOutEventPtr, BoardPowerControlEventTarget target) NN_NOEXCEPT;

}}}} // namespace nn::bpc::driver::detail
