﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/bpc/driver/bpc.h>

namespace nn { namespace bpc { namespace driver {

void Initialize() NN_NOEXCEPT
{;}

void Finalize() NN_NOEXCEPT
{;}

void ShutdownSystem() NN_NOEXCEPT
{
    NN_ABORT("[bpc] Shutdown is not implemented");
}

void RebootSystem() NN_NOEXCEPT
{
    NN_ABORT("[bpc] Reboot is not implemented");
}

nn::Result GetWakeupReason(WakeupReason* pOutWakeupReason) NN_NOEXCEPT
{
    NN_UNUSED(pOutWakeupReason);
    NN_RESULT_SUCCESS;
}

nn::Result GetShutdownReason(ShutdownReason* pOutShutdownReason) NN_NOEXCEPT
{
    NN_UNUSED(pOutShutdownReason);
    NN_RESULT_SUCCESS;
}

nn::Result GetAcOk(bool* pOutAcOk) NN_NOEXCEPT
{
    NN_UNUSED(pOutAcOk);
    NN_RESULT_SUCCESS;
}

void GetSleepButtonState(SleepButtonState* pOutState) NN_NOEXCEPT
{
    NN_UNUSED(pOutState);
}

nn::Result GetPowerButtonEventPtr(nn::os::SystemEventType** pOutEventPtr, EventTarget target) NN_NOEXCEPT
{
    NN_UNUSED(pOutEventPtr);
    NN_UNUSED(target);
    NN_RESULT_SUCCESS;
}

nn::Result GetBoardPowerControlEventPtr(nn::os::SystemEventType** pOutEventPtr, BoardPowerControlEventTarget target) NN_NOEXCEPT
{
    NN_UNUSED(pOutEventPtr);
    NN_UNUSED(target);
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::bpc::driver
