﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/result/result_HandlingUtility.h>
#include <nn/bluetooth/bluetooth_Result.h>
#include <nn/bluetooth/bluetooth_ResultProprietary.h>
#include <nn/bluetooth/bluetooth_ResultPrivate.h>
#include <nn/btm/user/btm_UserResult.h>

namespace nn { namespace bluetooth {
        static nn::Result ConvertResult(nn::Result result)
        {
            if (nn::btm::user::ResultInvalidArgument().Includes(result))
            {
                NN_ABORT_UNLESS_RESULT_SUCCESS(ResultInvalidArgument());
            }
            else if (nn::bluetooth::ResultBadParameter().Includes(result))
            {
                NN_ABORT_UNLESS_RESULT_SUCCESS(nn::bluetooth::ResultBadParameter());
            }
            else if (nn::btm::user::ResultBusyProcessingExclusiveApi().Includes(result))
            {
                return nn::bluetooth::ResultProcessingExclusiveApi();
            }
            else if (nn::btm::user::ResultBusyWorking().Includes(result) ||
                nn::btm::user::ResultBusy().Includes(result))
            {
                return nn::bluetooth::ResultSystemBusy();
            }
            else if (nn::bluetooth::ResultBleBusyError().Includes(result))
            {
                return nn::bluetooth::ResultGattBusy();
            }
            else if (nn::btm::user::ResultFailureLowLayerGeneral().Includes(result))
            {
                return nn::bluetooth::ResultGeneralError();
            }
            else if (nn::btm::user::ResultFailureLowLayer().Includes(result))
            {
                // TORIAEZU
                NN_ABORT_UNLESS_RESULT_SUCCESS(nn::btm::user::ResultFailureLowLayerCritical());
            }
            else if (nn::btm::user::ResultScanStartFailedFull().Includes(result))
            {
                return nn::bluetooth::ResultBleScanFull();
            }
            else if (nn::btm::user::ResultBleScan().Includes(result))
            {
                return nn::bluetooth::ResultBleScan();
            }
            else if (nn::btm::user::ResultBleConnectionNotFound().Includes(result))
            {
                return nn::bluetooth::ResultBleNotConnected();
            }
            else if (nn::bluetooth::ResultBleClientError().Includes(result))
            {
                return nn::bluetooth::ResultBleNotConnected();
            }
            else if (nn::btm::user::ResultBleConnectionFailedFull().Includes(result))
            {
                return nn::bluetooth::ResultBleConnectionFull();
            }
            else if (nn::btm::user::ResultBleConnectionAlreadyExist().Includes(result))
            {
                return nn::bluetooth::ResultBleAlreadyConnected();
            }
            else if (nn::btm::user::ResultBleConnection().Includes(result))
            {
                return nn::bluetooth::ResultBleConnection();
            }
            else if (nn::btm::user::ResultBlePairingNotSupported().Includes(result))
            {
                return nn::bluetooth::ResultBlePairingNotSupported();
            }
            else if (nn::btm::user::ResultBlePairing().Includes(result))
            {
                return nn::bluetooth::ResultBlePairing();
            }
            else if (nn::btm::user::ResultBleGattDataPathRegisterFailed().Includes(result))
            {
                return nn::bluetooth::ResultDatabaseFull();
            }
            else if (nn::btm::user::ResultBluetoothOff().Includes(result))
            {
                return nn::bluetooth::ResultBluetoothOff();
            }
            else if (nn::btm::user::ResultInvalidOperationForCurrentUsecase().Includes(result))
            {
                return nn::bluetooth::ResultInvalidWirelessState();
            }
            else if (nn::bluetooth::ResultHalCore().Includes(result) ||
                nn::bluetooth::ResultHalHidHost().Includes(result) ||
                nn::bluetooth::ResultHalBle().Includes(result))
            {
                return nn::bluetooth::ResultGeneralError();
            }

            // 上記変換に当てはまらないものは、そのまま（bluetooth_Result.h にあるものだけになっているはず）返す
            return result;
        }
}}  // namespace nn::bluetooth
