﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>      // for nn::sf::ExpHeapStaticAllocator

#include <nn/bluetooth/bluetooth_IBluetoothDriver.sfdl.h> // for IBluetoothDriver
#include <nn/bluetooth/bluetooth_Driver.h>           // for IBluetoothDriver
#include <nn/bluetooth/bluetooth_ServiceName.h>      // for IBluetoothDriver

namespace nn { namespace bluetooth {

namespace {

//-----------------------------------------------------------------------------
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct  BluetoothDriverByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, BluetoothDriverByHipcTag> BluetoothAllocator;

//-----------------------------------------------------------------------------
// BluetoothAllocator を静的コンストラクタで初期化するためのヘルパー
class BluetoothAllocatorInitializer
{
public:

    BluetoothAllocatorInitializer() NN_NOEXCEPT
    {
        BluetoothAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_BluetoothAllocatorInitializer;

}

//-----------------------------------------------------------------------------
//  Bluetoothドライバのサービスを HIPC として初期化して使用可能にします。
//
nn::sf::SharedPointer<IBluetoothDriver> CreateBluetoothDriverByHipc() NN_NOEXCEPT
{
    // BluetoothDriverServiceName のサービス名で示される HIPC サービスオブジェクトを
    // IBluetoothDriver としてプロキシクライアントを作成して返します。
    // アロケーションポリシーとして BluetoothAllocator::Policy を渡している。
    nn::sf::SharedPointer<IBluetoothDriver> ret;
    auto result = nn::sf::CreateHipcProxyByName<IBluetoothDriver, BluetoothAllocator::Policy>(&ret, BluetoothDriverServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

//-----------------------------------------------------------------------------

}}  // namespace nn::bluetooth

