﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/bgtc/bgtc_Result.h>

namespace nn { namespace bgtc {

    template <typename T>
    bool TryGetSettingsFwdbgValue(T* pOut, const char* pKeyString)
    {
        size_t bytes = nn::settings::fwdbg::GetSettingsItemValue(pOut, sizeof(T), "bgtc", pKeyString);
        return(bytes == sizeof(T));
    }

    template <typename T>
    T GetSettingsFwdbgValue(const char* pKeyString)
    {
        T outValue;

        if (!TryGetSettingsFwdbgValue(&outValue, pKeyString))
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(ResultSettingsFailure());
        }
        return outValue;
    }

    template <typename T>
    T GetSettingsFwdbgValue(const char* pKeyString, T defaultValue)
    {
        T outValue;

        if (!TryGetSettingsFwdbgValue(&outValue, pKeyString))
        {
            return defaultValue;
        }
        return outValue;
    }
}}
