﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/bgtc/bgtc_Task.h>
#include <nn/bgtc/detail/bgtc_TaskImpl.h>

namespace nn { namespace bgtc {

    Task::Task() NN_NOEXCEPT
        : m_pImpl(new detail::TaskImpl())
    {
    }

    Task::~Task() NN_NOEXCEPT
    {
        if (m_pImpl->IsInitialized())
        {
            m_pImpl->Finalize();
        }
    }

    Result Task::Initialize() NN_NOEXCEPT
    {
        return m_pImpl->Initialize();
    }

    bool Task::IsInitialized() NN_NOEXCEPT
    {
        return m_pImpl->IsInitialized();
    }

    void Task::Finalize() NN_NOEXCEPT
    {
        m_pImpl->Finalize();
    }

    Result Task::NotifyStarting() NN_NOEXCEPT
    {
        return m_pImpl->NotifyStarting();
    }

    void Task::NotifyFinished() NN_NOEXCEPT
    {
        m_pImpl->NotifyFinished();
    }

    nn::os::SystemEvent & Task::GetTriggerEvent() NN_NOEXCEPT
    {
        return m_pImpl->GetTriggerEvent();
    }

    void Task::Schedule(Interval intervalSeconds) NN_NOEXCEPT
    {
        m_pImpl->Schedule(intervalSeconds);
    }

    void Task::ScheduleUnsafe(Interval intervalSeconds) NN_NOEXCEPT
    {
        m_pImpl->ScheduleUnsafe(intervalSeconds);
    }

    void Task::SchedulePeriodic(Interval intervalSecondsFirst, Interval intervalSecondsPeriodic) NN_NOEXCEPT
    {
        m_pImpl->SchedulePeriodic(intervalSecondsFirst, intervalSecondsPeriodic);
    }

    Result Task::GetScheduledInterval(Interval * pOutSeconds) NN_NOEXCEPT
    {
        return m_pImpl->GetScheduledInterval(pOutSeconds);
    }

    Result Task::Unschedule() NN_NOEXCEPT
    {
        return m_pImpl->Unschedule();
    }

    nn::os::SystemEvent & Task::GetScheduleEvent() NN_NOEXCEPT
    {
        return m_pImpl->GetScheduleEvent();
    }

    void Task::SetClientName(const char* pName) NN_NOEXCEPT
    {
        m_pImpl->SetClientName(pName);
    }
}}
