﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn
{
    [CppRefPath(@"<nn/nn_ApplicationId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }
}

namespace nn.bcat
{
    [CppRefPath(@"<nn/bcat/bcat_Types.h>")]
    [ExternalStruct(32, 1)]
    public struct FileName
    {
    }

    [CppRefPath(@"<nn/bcat/bcat_Types.h>")]
    [ExternalStruct(32, 1)]
    public struct DirectoryName
    {
    }

    [CppRefPath(@"<nn/bcat/bcat_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Digest
    {
    }

    [CppRefPath(@"<nn/bcat/bcat_Types.h>")]
    [ExternalStruct(56, 8)]
    public struct DeliveryCacheDirectoryEntry
    {
    }

    [CppRefPath(@"<nn/bcat/bcat_TypesDebug.h>")]
    [ExternalStruct(64, 8)]
    public struct TaskInfo
    {
    }

    [CppRefPath(@"<nn/bcat/bcat_TypesDebug.h>")]
    [ExternalStruct(16, 8)]
    public struct PushNotificationLog
    {
    }
}

namespace nn.bcat.detail
{
    [CppRefPath(@"<nn/bcat/detail/bcat_TypesDetail.h>")]
    [ExternalStruct(512, 8)]
    [LargeData]
    public struct DeliveryCacheProgressImpl
    {
    }
}

namespace nn.bcat.detail.ipc
{
    [CppRefPath(@"<nn/bcat/detail/ipc/bcat_IDeliveryCacheFileService.sfdl.h>")]
    public partial interface IDeliveryCacheFileService : IServiceObject {}

    public partial interface IDeliveryCacheFileService : IServiceObject
    {
        [MethodId(0)]
        Result Open(DirectoryName dirName, FileName fileName);

        [MethodId(1)]
        Result Read(Out<uint64_t> outSize,
            int64_t offset, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer buffer);

        [MethodId(2)]
        Result GetSize(Out<int64_t> outSize);

        [MethodId(3)]
        Result GetDigest(Out<Digest> outDigest);
    }
}

namespace nn.bcat.detail.ipc
{
    [CppRefPath(@"<nn/bcat/detail/ipc/bcat_IDeliveryCacheDirectoryService.sfdl.h>")]
    public partial interface IDeliveryCacheDirectoryService : IServiceObject {}

    public partial interface IDeliveryCacheDirectoryService : IServiceObject
    {
        [MethodId(0)]
        Result Open(DirectoryName dirName);

        [MethodId(1)]
        Result Read(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<DeliveryCacheDirectoryEntry> outEntries);

        [MethodId(2)]
        Result GetCount(Out<int32_t> outCount);
    }
}

namespace nn.bcat.detail.ipc
{
    [CppRefPath(@"<nn/bcat/detail/ipc/bcat_IDeliveryCacheStorageService.sfdl.h>")]
    public partial interface IDeliveryCacheStorageService : IServiceObject {}

    public partial interface IDeliveryCacheStorageService : IServiceObject
    {
        [MethodId(0)]
        Result CreateFileService(Out<IDeliveryCacheFileService> outService);

        [MethodId(1)]
        Result CreateDirectoryService(Out<IDeliveryCacheDirectoryService> outService);

        [MethodId(10)]
        Result EnumerateDeliveryCacheDirectory(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<DirectoryName> outDirectoryNames);
    }
}

namespace nn.bcat.detail.ipc
{
    [CppRefPath(@"<nn/bcat/detail/ipc/bcat_IDeliveryCacheProgressService.sfdl.h>")]
    public partial interface IDeliveryCacheProgressService : IServiceObject {}

    public partial interface IDeliveryCacheProgressService : IServiceObject
    {
        [MethodId(0)]
        Result GetEvent(Out<NativeHandle> outEvent);

        [MethodId(1)]
        Result GetImpl(Out<DeliveryCacheProgressImpl> outImpl);
    }
}

namespace nn.bcat.detail.ipc
{
    [CppRefPath(@"<nn/bcat/detail/ipc/bcat_IBcatService.sfdl.h>")]
    public partial interface IBcatService : IServiceObject {}

    ////////////////////////////////////////////////////////////////////////////////
    // Generic API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IBcatService : IServiceObject
    {
        [MethodId(10100)]
        Result RequestSyncDeliveryCache(Out<IDeliveryCacheProgressService> outService);

        [MethodId(10101)]
        Result RequestSyncDeliveryCacheWithDirectoryName(Out<IDeliveryCacheProgressService> outService, DirectoryName dirName);

        [MethodId(10200)]
        Result CancelSyncDeliveryCacheRequest();
    }

    ////////////////////////////////////////////////////////////////////////////////
    // System API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IBcatService : IServiceObject
    {
        [MethodId(20100)]
        Result RequestSyncDeliveryCacheWithApplicationId(Out<IDeliveryCacheProgressService> outService,
            ApplicationId appId, uint32_t appVersion);

        [MethodId(20101)]
        Result RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(Out<IDeliveryCacheProgressService> outService,
            ApplicationId appId, uint32_t appVersion, DirectoryName dirName);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Manager API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IBcatService : IServiceObject
    {
        [MethodId(30100)]
        Result SetPassphrase(ApplicationId appId, InArray<char_t> passphrase);

        [MethodId(30200)]
        Result RegisterBackgroundDeliveryTask(ApplicationId appId, uint32_t appVersion);

        [MethodId(30201)]
        Result UnregisterBackgroundDeliveryTask(ApplicationId appId);

        [MethodId(30202)]
        Result BlockDeliveryTask(ApplicationId appId);

        [MethodId(30203)]
        Result UnblockDeliveryTask(ApplicationId appId);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Debug API
    ////////////////////////////////////////////////////////////////////////////////

    public partial interface IBcatService : IServiceObject
    {
        [MethodId(90100)]
        Result EnumerateBackgroundDeliveryTask(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<TaskInfo> outInfos);

        [MethodId(90200)]
        Result GetDeliveryList(Out<uint64_t> outSize, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer buffer,
            ApplicationId appId);

        [MethodId(90201)]
        Result ClearDeliveryCacheStorage(ApplicationId appId);

        [MethodId(90300)]
        Result GetPushNotificationLog(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<PushNotificationLog> outLogs);
    }
}

namespace nn.bcat.detail.ipc
{
    [CppRefPath(@"<nn/bcat/detail/ipc/bcat_IServiceCreator.sfdl.h>")]
    public partial interface IServiceCreator : IServiceObject {};

    public partial interface IServiceCreator : IServiceObject
    {
        [MethodId(0)]
        Result CreateBcatService(Out<IBcatService> outService, [ProcessId] Bit64 processId);

        [MethodId(1)]
        Result CreateDeliveryCacheStorageService(Out<IDeliveryCacheStorageService> outService, [ProcessId] Bit64 processId);

        [MethodId(2)]
        Result CreateDeliveryCacheStorageServiceWithApplicationId(Out<IDeliveryCacheStorageService> outService, ApplicationId appId);
    }
}
