﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/util/bcat_Account.h>
#include <nn/account.h>
#include <nn/account/account_ApiForSystemServices.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace util {

bool Account::IsNetworkServiceAccountAvailable() NN_NOEXCEPT
{
    nn::account::Uid uids[nn::account::UserCountMax];
    int count;

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::account::ListAllUsers(&count, uids, nn::account::UserCountMax));

    for (int i = 0; i < count; i++)
    {
        nn::account::NetworkServiceAccountManager manager;

        if (nn::account::GetNetworkServiceAccountManager(&manager, uids[i]).IsSuccess())
        {
            bool isAvailable;

            if (manager.IsNetworkServiceAccountAvailable(&isAvailable).IsSuccess() && isAvailable)
            {
                return true;
            }
        }
    }

    return false;
}

}}}}}
