﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn {
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpanType
    {
    }
    namespace audioctrl {
        [CppRefPath(@"<nn/audioctrl/audioctrl_PlayReport.h>")]
        [ExternalStruct(2, 1)]
        public struct PlayReportAudioVolume
        {
        }

        [CppRefPath(@"<nn/audioctrl/audioctrl_PlayReport.h>")]
        [ExternalStruct(7, 1)]
        public struct PlayReportAudioVolumeData
        {
        }
    }
}

namespace nn.audioctrl.detail
{
    [CppRefPath(@"<nn/audioctrl/detail/audio_IAudioController.h>")]
    interface IAudioController : IServiceObject
    {
        [MethodId(0)]
        Result GetTargetVolume(uint32_t target, Out<int32_t> volume);

        [MethodId(1)]
        Result SetTargetVolume(uint32_t target, int32_t volume);

        [MethodId(2)]
        Result GetTargetVolumeMin(Out<int32_t> volume);

        [MethodId(3)]
        Result GetTargetVolumeMax(Out<int32_t> volume);

        [MethodId(4)]
        Result IsTargetMute(uint32_t target, Out<bool> isMute);

        [MethodId(5)]
        Result SetTargetMute(uint32_t target, bool isMute);

        [MethodId(6)]
        Result IsTargetConnected(uint32_t target, Out<bool> isConnected);

        [MethodId(7)]
        Result SetDefaultTarget(uint32_t target, nn.TimeSpanType fadeOutTime, nn.TimeSpanType fadeInTime);

        [MethodId(8)]
        Result GetDefaultTarget(Out<int32_t> defaultTarget);

        [MethodId(9)]
        Result GetAudioOutputMode(Out<uint32_t> mode, uint32_t target);

        [MethodId(10)]
        Result SetAudioOutputMode(uint32_t target, uint32_t mode);

        [MethodId(11)]
        Result SetForceMutePolicy(int32_t policy);

        [MethodId(12)]
        Result GetForceMutePolicy(Out<int32_t> policy);

        [MethodId(13)]
        Result GetOutputModeSetting(Out<uint32_t> mode, uint32_t target);

        [MethodId(14)]
        Result SetOutputModeSetting(uint32_t target, uint32_t mode);

        [MethodId(15)]
        Result SetOutputTarget(uint32_t target);

        [MethodId(16)]
        Result SetInputTargetForceEnabled(bool isEnabled);

        [MethodId(17)]
        Result SetHeadphoneOutputLevelMode(uint32_t mode);

        [MethodId(18)]
        Result GetHeadphoneOutputLevelMode(Out<uint32_t> mode);

        [MethodId(19)]
        Result AcquireAudioVolumeUpdateEventForPlayReport(Out<NativeHandle> handle);

        [MethodId(20)]
        Result AcquireAudioOutputDeviceUpdateEventForPlayReport(Out<NativeHandle> handle);

        [MethodId(21)]
        Result GetAudioOutputTargetForPlayReport(Out<uint32_t> target);

        [MethodId(22)]
        Result NotifyHeadphoneVolumeWarningDisplayedEvent();

        [MethodId(23)]
        Result SetSystemOutputMasterVolume(float volume);

        [MethodId(24)]
        Result GetSystemOutputMasterVolume(Out<float> volume);

        [MethodId(25)]
        Result GetAudioVolumeDataForPlayReport(Out<nn.audioctrl.PlayReportAudioVolumeData> volume);

        [MethodId(26)]
        Result UpdateHeadphoneSettings(bool isRestricted);
    }
}

