﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/ovln/format/ovln_AudioMessage.h>
#include <nn/audioctrl/audioctrl_AudioControllerTypes.h>

namespace nn { namespace audioctrl { namespace server { namespace detail {

class OverlaySenderController
{
    NN_DISALLOW_COPY( OverlaySenderController );
    NN_DISALLOW_MOVE( OverlaySenderController );

public:
    enum class VolumeChangeReason
    {
        VolumeChanged,
        MuteChanged,
        OutputTargetChanged,
    };

private:
    nn::ovln::SenderForOverlayType m_VolumeChangeSender;
    nn::ovln::SenderForOverlayType m_MuteChangeSender;
    nn::ovln::SenderForOverlayType m_AudioOutputTargetChangeSender;
    nn::ovln::SenderForOverlayType m_HeadphoneWarningNoticeSender;
    nn::ovln::SenderForOverlayType& GetVolumeChangeMessageSender(VolumeChangeReason reason) NN_NOEXCEPT;
    nn::ovln::format::AudioOutputTarget ConvertToAudioOutputTarget(AudioTarget target) const NN_NOEXCEPT;

public:
    OverlaySenderController() {};
    ~OverlaySenderController() {};
    struct VolumeChangeDetailReasonFlag
    {
        typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag>::Flag<0> upButtonPressed;
        typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag>::Flag<1> downButtonPressed;
        typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag>::Flag<2> upAndDownButtonPressed;
        typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag>::Flag<3> headphoneMicJackPlugged;
        typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag>::Flag<4> headphoneMicJackUnplugged;
        typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag>::Flag<5> usbOutputDeviceConnected;
        typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag>::Flag<6> usbOutputDeviceDisconnected;
    };

    typedef ::nn::util::BitFlagSet<32, VolumeChangeDetailReasonFlag> VolumeChangeDetailReasonFlagSet;

    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void SendVolumeChangeMessage(int volume, bool mute, AudioTarget target, VolumeChangeReason reason, VolumeChangeDetailReasonFlagSet detailReason) NN_NOEXCEPT;
    void SendHeadphoneVolumeWarningNoticeMessage() NN_NOEXCEPT;
};

}}}}  // namespace nn::audioctrl::server::detail
