﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/audioctrl/detail/audioctrl_IAudioController.h>

namespace nn { namespace audioctrl { namespace server { namespace detail {

class AudioControllerImpl : public nn::sf::ISharedObject
{
public:
    AudioControllerImpl() NN_NOEXCEPT;
    virtual ~AudioControllerImpl() NN_NOEXCEPT;
    Result GetTargetVolume(int32_t target, nn::sf::Out<std::int32_t> outMin) NN_NOEXCEPT;
    Result SetTargetVolume(int32_t target, int32_t volume) NN_NOEXCEPT;
    Result GetTargetVolumeMin(nn::sf::Out<std::int32_t> outMin) NN_NOEXCEPT;
    Result GetTargetVolumeMax(nn::sf::Out<std::int32_t> outMin) NN_NOEXCEPT;
    Result IsTargetMute(int32_t target, nn::sf::Out<bool> isMute) NN_NOEXCEPT;
    Result SetTargetMute(int32_t target, bool isMute) NN_NOEXCEPT;
    Result IsTargetConnected(int32_t target, nn::sf::Out<bool> isConnected) NN_NOEXCEPT;
    Result SetDefaultTarget(std::uint32_t target, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT;
    Result GetDefaultTarget(nn::sf::Out<std::int32_t> defaultTarget) NN_NOEXCEPT;
    Result GetOutputModeSetting(nn::sf::Out<std::uint32_t> mode, uint32_t target) NN_NOEXCEPT;
    Result SetOutputModeSetting(uint32_t target, uint32_t mode) NN_NOEXCEPT;
    Result GetAudioOutputMode(nn::sf::Out<std::uint32_t> mode, uint32_t target) NN_NOEXCEPT;
    Result SetAudioOutputMode(uint32_t target, uint32_t mode) NN_NOEXCEPT;
    Result SetForceMutePolicy(std::int32_t policy) NN_NOEXCEPT;
    Result GetForceMutePolicy(nn::sf::Out<std::int32_t> policy) NN_NOEXCEPT;
    Result SetOutputTarget(std::uint32_t target) NN_NOEXCEPT;
    Result SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT;
    Result SetHeadphoneOutputLevelMode(std::uint32_t mode) NN_NOEXCEPT;
    Result GetHeadphoneOutputLevelMode(nn::sf::Out<std::uint32_t> mode) NN_NOEXCEPT;
    Result AcquireAudioVolumeUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    Result AcquireAudioOutputDeviceUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    Result GetAudioOutputTargetForPlayReport(nn::sf::Out<std::uint32_t> target) NN_NOEXCEPT;
    Result NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT;
    Result SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT;
    Result GetSystemOutputMasterVolume(nn::sf::Out<float> volume) NN_NOEXCEPT;
    Result GetAudioVolumeDataForPlayReport(nn::sf::Out<::nn::audioctrl::PlayReportAudioVolumeData> data) NN_NOEXCEPT;
    Result UpdateHeadphoneSettings(bool isRestricted) NN_NOEXCEPT;
};

}}}}  // namespace nn::audio::server::detail
