﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/audioctrl/server/audioctrl_AudioControllerHipcServer.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "detail/audioctrl_AudioControllerImpl.h"
#include "../detail/audioctrl_CreateAudioController.h"
#include "../detail/audioctrl_ServiceName.h"
#include "detail/audioctrl_AudioControllerService.h"

#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX)
#include <nn/nn_SdkLog.h>

#include <nn/codec/server/codec_HardwareOpusDecoderManager.h>
#include <nn/audio/server/audio_FirmwareDebugSettings.h>
#include <nne/audio/audio.h>

using namespace nne::audio;

extern const char adsp_os_bin_begin[];
extern const char adsp_os_bin_end[];
extern const char vector_bin_begin[];
extern const char vector_bin_end[];

#endif

namespace nn { namespace audioctrl { namespace server {

namespace {

class MyServerManager : public nn::sf::HipcSimpleAllInOneServerManager<30, 1>
{

};

std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_MyServerManagerStorage;
MyServerManager* g_pMyServerManager;

}  // namespace anonymous

void InitializeAudioControllerServer(bool hasCodecIc, bool hasHda, bool isUacEnabled) NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager == nullptr);

    detail::InitializeAudioControllerService(hasCodecIc, hasHda, isUacEnabled);

    g_pMyServerManager = new (&g_MyServerManagerStorage) MyServerManager;

    auto sessionCountMax = 30;
    g_pMyServerManager->RegisterObjectForPort(nn::audioctrl::detail::CreateAudioControllerByDfc(), sessionCountMax, nn::audioctrl::detail::AudioControllerServiceName);
    g_pMyServerManager->Start();
}

void LoopAudioControllerServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->LoopAuto();
}

void RequestStopAudioControllerServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->RequestStop();
}

void FinalizeAudioControllerServer() NN_NOEXCEPT
{
    detail::FinalizeAudioControllerService();

    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->~MyServerManager();
    g_pMyServerManager = nullptr;
}

}}}  // namespace nn::audioctrl::server

