﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include "audio_CreateAudioOutManager.h"
#include "audio_ServiceName.h"
#include "../server/audio_AudioOutManagerImpl.h"

#include "../server/audio_AudioOutManagerForAppletImpl.h"
#include "../server/audio_AudioOutManagerForDebuggerImpl.h"

namespace nn {
namespace audio {

nn::sf::UnmanagedServiceObject<detail::IAudioOutManager, server::AudioOutManagerImpl> g_AudioOutManager;
nn::sf::UnmanagedServiceObject<detail::IAudioOutManagerForDebugger, server::AudioOutManagerForDebuggerImpl> g_AudioOutManagerForDebugger;
nn::sf::UnmanagedServiceObject<detail::IAudioOutManagerForApplet, server::AudioOutManagerForAppletImpl> g_AudioOutManagerForApplet;

nn::sf::SharedPointer<detail::IAudioOutManager> CreateAudioOutManagerByDfc() NN_NOEXCEPT
{
    return g_AudioOutManager.GetShared();
}

nn::sf::SharedPointer<detail::IAudioOutManagerForApplet> CreateAudioOutManagerForAppletByDfc() NN_NOEXCEPT
{
    return g_AudioOutManagerForApplet.GetShared();
}

nn::sf::SharedPointer<detail::IAudioOutManagerForDebugger> CreateAudioOutManagerForDebuggerByDfc() NN_NOEXCEPT
{
    return g_AudioOutManagerForDebugger.GetShared();
}

}  // namespace audio
}  // namespace nn
