﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include "audio_CreateAudioInManager.h"
#include "audio_ServiceName.h"

#include "../server/audio_AudioInManagerImpl.h"
#include "../server/audio_AudioInManagerForAppletImpl.h"
#include "../server/audio_AudioInManagerForDebuggerImpl.h"

namespace nn {
namespace audio {

namespace {

struct CreateAudioInManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateAudioInManagerByHipcTag> MyAllocator;

class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}  // namespace anonymous

nn::sf::SharedPointer<detail::IAudioInManager> CreateAudioInManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioInManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioInManager, MyAllocator::Policy>(&ret, AudioInServiceForUserName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

nn::sf::SharedPointer<detail::IAudioInManagerForApplet> CreateAudioInManagerForAppletByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioInManagerForApplet> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioInManagerForApplet, MyAllocator::Policy>(&ret, AudioInServiceForAppletName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

nn::sf::SharedPointer<detail::IAudioInManagerForDebugger> CreateAudioInManagerForDebuggerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioInManagerForDebugger> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioInManagerForDebugger, MyAllocator::Policy>(&ret, AudioInServiceForDebuggerName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

/**/
}  // namespace audio
}  // namespace nns
