﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/audio/detail/audio_IAudioDebugManager.h>
#include "audio_CreateAudioDebugManager.h"
#include "audio_ServiceName.h"
#include "../server/audio_AudioDebugManagerImpl.h"

namespace nn {
namespace audio {

nn::sf::UnmanagedServiceObject<detail::IAudioDebugManager, server::AudioDebugManagerImpl> g_AudioDebugManager;

nn::sf::SharedPointer<detail::IAudioDebugManager> CreateAudioDebugManagerByDfc() NN_NOEXCEPT
{
    return g_AudioDebugManager.GetShared();
}

}  // namespace audio
}  // namespace nn
