﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/Result/result_HandlingUtility.h>
#include "audio_AudioUacInSession-os.horizon.h"
#include "../common/audio_AudioInPrivate.h"
#include "../audio_AudioHardware.h"
#include "audio_UacManager.h"

namespace nn { namespace audio {

namespace server {

namespace {
    const char* g_DeviceInName = nn::audio::common::DeviceAudioIn;
}

namespace detail {
AudioUacInSession::AudioUacInSession(int32_t sessionId, nn::os::SystemEvent& releaseClientBufferEvent) NN_NOEXCEPT
    : AudioSession(sessionId, releaseClientBufferEvent, server::AudioSessionType_Input)
{
}

AudioUacInSession::~AudioUacInSession() NN_NOEXCEPT
{
}

const char* AudioUacInSession::GetDefaultName() NN_NOEXCEPT
{
    return server::g_DeviceInName;
}

Result AudioUacInSession::IsSupported(const char* name, const server::SessionFormat& format) NN_NOEXCEPT
{
    //Only checks if gmix/ahub session is supported.
    NN_RESULT_THROW_UNLESS(0 == strnlen(name, AudioIn::NameLength) || 0 == strncmp(name, GetDefaultName(), AudioIn::NameLength), nn::audio::ResultNotFound());
    // Fail if the sampleRate is not 0 or 48000
    NN_RESULT_THROW_UNLESS((0 == format.sampleRate || 48000 == format.sampleRate), ResultInvalidSampleRate());

    NN_RESULT_SUCCESS;
}

AudioInState AudioUacInSession::GetState() NN_NOEXCEPT
{
    switch(m_State)
    {
        case server::SessionState_Started:
            return AudioInState_Started;
        case server::SessionState_Stopped:
            return AudioInState_Stopped;
        default:
            NN_UNEXPECTED_DEFAULT;
    }
    return AudioInState_Stopped;
}

float AudioUacInSession::GetDeviceGain() NN_NOEXCEPT
{
    return 1.0f;
}

Result AudioUacInSession::SetDeviceGain(float gain) NN_NOEXCEPT
{
    NN_UNUSED(gain);
    NN_RESULT_THROW(ResultNotSupported());
}

void AudioUacInSession::SetName(const char* name, int length) NN_NOEXCEPT
{
    strncpy(m_Name, name, length);
    m_Name[ sizeof(m_Name) - 1 ] = '\0';
}

}}} // namespace nn::audio::detail
