﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#pragma warning( push )
#pragma warning ( disable : 4668 )
#include <mmdeviceapi.h>
#include <audioclient.h>
#pragma warning( pop )

namespace nn {
namespace audio {

class AudioOutClientImplByWin32
{
public:
    Result Initialize(const char* name) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    int GetSampleRate() const NN_NOEXCEPT;
    int GetChannelCount() const NN_NOEXCEPT;
    int GetBitsPerSample() const NN_NOEXCEPT;
    void Wait() NN_NOEXCEPT;
    void* AcquireBuffer(int sampleCount) NN_NOEXCEPT;
    void ReleaseBuffer(int sampleCount) NN_NOEXCEPT;
private:
    Result InitializeCommon(IMMDevice* pDevice, int SampleRate = 0) NN_NOEXCEPT;

    int m_SampleRate;
    int m_ChannelCount;
    int m_BitsPerSample;

    IMMDevice* m_pDevice;
    IAudioClient* m_pAudioClient;
    IAudioRenderClient* m_pAudioRenderClient;
    HANDLE m_hEvent;

    static const int BufferSeparationCount = 2;

    int m_BufferSampleCount;
};

typedef AudioOutClientImplByWin32 AudioOutClientImpl;

}  // namespace audio
}  // namespace nn
