﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <mutex>
#include <nn/nn_TimeSpan.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/audio/audio_Result.h>
#include "audio_UpsamplerManager.h"

namespace nn { namespace audio {

UpsamplerInfo::UpsamplerInfo() NN_NOEXCEPT
        : pUpsamplerManager(nullptr)
        , pOutBuffers(nullptr)
        , sampleCount(0)
        , inputCount(0)
        , isInUse(false)
{
    std::memset(input, 0, sizeof(input));
    std::memset(srcbl, 0, sizeof(srcbl));
}

namespace server {

UpsamplerManager::UpsamplerManager(int count, UpsamplerInfo* pInfo, int8_t* pBuffers) NN_NOEXCEPT
    : m_Count(count)
    , m_Infos(pInfo)
    , pOutBuffers(pBuffers)
    , m_Mutex(true)
{
}

UpsamplerInfo* UpsamplerManager::Allocate() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);

    UpsamplerInfo* p = nullptr;
    for (int i = 0; i < m_Count; ++i)
    {
        if (!m_Infos[i].isInUse)
        {
            p = &m_Infos[i];
            p->isInUse = true;
            p->sampleCount = 240;   // \TBD TODO needs to match actual output but only 48K supported for now
            p->pOutBuffers = (int32_t*)&pOutBuffers[i * sizeof(int32_t) * p->sampleCount * p->InputCountMax];
            p->pUpsamplerManager = this;
            break;
        }
    }
    return p;
}

void UpsamplerManager::Free(UpsamplerInfo* pInfo) NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);

    pInfo->isInUse = false;
}

}}}  // namespace nn::audio::server
