﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_Thread.h>
#include <nn/applet/applet_Types.h>
#include "audio_AudioRenderSystem.h"

namespace nn { namespace audio { namespace server {

class AudioRenderSystemManager
{
    NN_DISALLOW_COPY( AudioRenderSystemManager );
    NN_DISALLOW_MOVE( AudioRenderSystemManager );
private:
    nn::os::Mutex m_Mutex;
    nn::os::Mutex m_MutexForInitializeFinalize;
    nn::os::ThreadType m_Thread;
    std::atomic<bool> m_IsActive;
    AudioRenderSystemList m_InstanceList;
private:
    AudioRenderSystemManager() NN_NOEXCEPT;
    ~AudioRenderSystemManager() NN_NOEXCEPT;
    void ThreadFunctionImpl() NN_NOEXCEPT;
    static void ThreadFunction(void* arg) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    static AudioRenderSystemManager* sManagerInstance;
public:
    static void CreateInstance(void* buffer, size_t bufferSize) NN_NOEXCEPT;
    static void DeleteInstance() NN_NOEXCEPT;
    static AudioRenderSystemManager& GetInstance() NN_NOEXCEPT;
    bool Add(AudioRenderSystem& instance) NN_NOEXCEPT;
    void Remove(AudioRenderSystem& instance) NN_NOEXCEPT;
    void ReleaseAudioRenderSystem(const AudioRenderSystem* p) NN_NOEXCEPT;
    void Dump() NN_NOEXCEPT;
    void Wake() NN_NOEXCEPT;
    void Sleep() NN_NOEXCEPT;
    bool IsValidAudioRenderSystem(const AudioRenderSystem* p) const NN_NOEXCEPT;
};

}}}  // namespace nn::audio::server
