﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/profiler.h>

#include "audio_AudioDebugManagerImpl.h"
#include "../dsp/audio_Dsp.h"
#include "../dsp/audio_DspProfiler.h"

namespace nn { namespace audio { namespace server {

namespace
{
    const int g_ProfilerBufferSize = 16 * 1024 * 1024;
    NN_OS_ALIGNAS_THREAD_STACK uint8_t g_ProfilerBuffer[g_ProfilerBufferSize];
}

AudioDebugManagerImpl::AudioDebugManagerImpl() NN_NOEXCEPT
{
    m_HeapHandle = nn::lmem::CreateExpHeap(&m_HeapBuffer, sizeof(m_HeapBuffer), nn::lmem::CreationOption_NoOption);
    m_Allocator.Attach(m_HeapHandle);
}

AudioDebugManagerImpl::~AudioDebugManagerImpl() NN_NOEXCEPT
{
    nn::lmem::DestroyExpHeap(m_HeapHandle);
}


nn::Result AudioDebugManagerImpl::StartDspProfiler(nn::sf::NativeHandle processHandle, uint64_t bufferPtr, uint32_t bufferSize) NN_NOEXCEPT
{
    dsp::StartDspProfiler(processHandle.GetOsHandle(), bufferPtr, bufferSize);
    processHandle.Detach();
    NN_RESULT_SUCCESS;
}

nn::Result AudioDebugManagerImpl::StopDspProfiler() NN_NOEXCEPT
{
    dsp::StopDspProfiler();
    NN_RESULT_SUCCESS;
}

nn::Result AudioDebugManagerImpl::StartCpuProfiler() NN_NOEXCEPT
{
    return nn::profiler::Initialize(g_ProfilerBuffer, sizeof(g_ProfilerBuffer));
}

nn::Result AudioDebugManagerImpl::StopCpuProfiler() NN_NOEXCEPT
{
    nn::profiler::Finalize();
    NN_RESULT_SUCCESS;
}

}}}  // namespace nn::audio::server
