﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/* the sinc function table  */
enum { FILTER_TABLE_LENGTH = 2560 }; /* Filter table length */

static const uint16_t Nhxn = 15; /* Q15 format */

/* h is a table of one half of the filter impulse response */
static const int16_t h[] /* Impulse response Q15 format */ = {
    32767,
    32766,
    32764,
    32759,
    32754,
    32746,
    32737,
    32726,
    32713,
    32699,
    32683,
    32665,
    32646,
    32625,
    32602,
    32578,
    32551,
    32524,
    32494,
    32463,
    32431,
    32396,
    32360,
    32323,
    32283,
    32242,
    32200,
    32156,
    32110,
    32062,
    32013,
    31962,
    31910,
    31856,
    31801,
    31744,
    31685,
    31625,
    31563,
    31499,
    31434,
    31368,
    31300,
    31230,
    31159,
    31086,
    31012,
    30936,
    30859,
    30780,
    30699,
    30618,
    30534,
    30450,
    30363,
    30276,
    30187,
    30096,
    30004,
    29911,
    29816,
    29720,
    29622,
    29523,
    29422,
    29321,
    29218,
    29113,
    29007,
    28900,
    28792,
    28682,
    28571,
    28458,
    28345,
    28230,
    28114,
    27996,
    27877,
    27758,
    27636,
    27514,
    27391,
    27266,
    27140,
    27013,
    26885,
    26756,
    26625,
    26494,
    26361,
    26228,
    26093,
    25957,
    25820,
    25682,
    25543,
    25403,
    25262,
    25121,
    24978,
    24834,
    24689,
    24543,
    24397,
    24249,
    24101,
    23952,
    23802,
    23651,
    23499,
    23346,
    23193,
    23039,
    22884,
    22728,
    22571,
    22414,
    22256,
    22097,
    21938,
    21778,
    21617,
    21456,
    21294,
    21131,
    20968,
    20804,
    20640,
    20475,
    20309,
    20143,
    19977,
    19810,
    19642,
    19474,
    19306,
    19137,
    18967,
    18798,
    18627,
    18457,
    18286,
    18115,
    17943,
    17771,
    17599,
    17427,
    17254,
    17081,
    16907,
    16734,
    16560,
    16386,
    16212,
    16038,
    15863,
    15689,
    15514,
    15339,
    15164,
    14989,
    14814,
    14639,
    14463,
    14288,
    14113,
    13938,
    13763,
    13587,
    13412,
    13237,
    13062,
    12887,
    12713,
    12538,
    12363,
    12189,
    12015,
    11841,
    11667,
    11493,
    11320,
    11147,
    10974,
    10801,
    10629,
    10457,
    10285,
    10114,
    9942,
    9772,
    9601,
    9431,
    9262,
    9092,
    8923,
    8755,
    8587,
    8420,
    8253,
    8086,
    7920,
    7754,
    7589,
    7425,
    7261,
    7097,
    6934,
    6772,
    6610,
    6449,
    6289,
    6129,
    5970,
    5811,
    5653,
    5496,
    5340,
    5184,
    5029,
    4874,
    4721,
    4568,
    4415,
    4264,
    4113,
    3963,
    3814,
    3666,
    3519,
    3372,
    3226,
    3081,
    2937,
    2794,
    2651,
    2510,
    2369,
    2230,
    2091,
    1953,
    1816,
    1680,
    1545,
    1411,
    1277,
    1145,
    1014,
    884,
    754,
    626,
    499,
    373,
    247,
    123,
    0,
    -121,
    -242,
    -362,
    -481,
    -599,
    -716,
    -832,
    -946,
    -1060,
    -1173,
    -1284,
    -1394,
    -1503,
    -1611,
    -1718,
    -1824,
    -1929,
    -2032,
    -2135,
    -2236,
    -2336,
    -2435,
    -2533,
    -2630,
    -2725,
    -2820,
    -2913,
    -3005,
    -3095,
    -3185,
    -3274,
    -3361,
    -3447,
    -3532,
    -3615,
    -3698,
    -3779,
    -3859,
    -3938,
    -4016,
    -4092,
    -4168,
    -4242,
    -4315,
    -4386,
    -4457,
    -4526,
    -4594,
    -4661,
    -4727,
    -4791,
    -4854,
    -4916,
    -4977,
    -5037,
    -5095,
    -5152,
    -5208,
    -5263,
    -5317,
    -5369,
    -5420,
    -5470,
    -5519,
    -5567,
    -5613,
    -5658,
    -5702,
    -5745,
    -5787,
    -5827,
    -5867,
    -5905,
    -5942,
    -5977,
    -6012,
    -6045,
    -6078,
    -6109,
    -6139,
    -6167,
    -6195,
    -6222,
    -6247,
    -6271,
    -6294,
    -6316,
    -6337,
    -6357,
    -6376,
    -6393,
    -6409,
    -6425,
    -6439,
    -6452,
    -6464,
    -6475,
    -6485,
    -6494,
    -6502,
    -6509,
    -6514,
    -6519,
    -6522,
    -6525,
    -6527,
    -6527,
    -6527,
    -6525,
    -6523,
    -6519,
    -6515,
    -6509,
    -6503,
    -6496,
    -6487,
    -6478,
    -6468,
    -6457,
    -6445,
    -6432,
    -6418,
    -6403,
    -6387,
    -6371,
    -6353,
    -6335,
    -6316,
    -6296,
    -6275,
    -6253,
    -6230,
    -6207,
    -6183,
    -6158,
    -6132,
    -6105,
    -6078,
    -6050,
    -6021,
    -5991,
    -5961,
    -5930,
    -5898,
    -5865,
    -5832,
    -5798,
    -5763,
    -5728,
    -5692,
    -5655,
    -5618,
    -5580,
    -5541,
    -5502,
    -5462,
    -5421,
    -5380,
    -5339,
    -5296,
    -5253,
    -5210,
    -5166,
    -5122,
    -5077,
    -5031,
    -4985,
    -4939,
    -4891,
    -4844,
    -4796,
    -4747,
    -4699,
    -4649,
    -4599,
    -4549,
    -4499,
    -4448,
    -4396,
    -4344,
    -4292,
    -4240,
    -4187,
    -4133,
    -4080,
    -4026,
    -3972,
    -3917,
    -3862,
    -3807,
    -3752,
    -3696,
    -3640,
    -3584,
    -3528,
    -3471,
    -3414,
    -3357,
    -3300,
    -3242,
    -3185,
    -3127,
    -3069,
    -3011,
    -2952,
    -2894,
    -2835,
    -2777,
    -2718,
    -2659,
    -2600,
    -2541,
    -2482,
    -2423,
    -2364,
    -2305,
    -2245,
    -2186,
    -2127,
    -2067,
    -2008,
    -1949,
    -1890,
    -1830,
    -1771,
    -1712,
    -1653,
    -1594,
    -1535,
    -1476,
    -1417,
    -1358,
    -1300,
    -1241,
    -1183,
    -1125,
    -1067,
    -1009,
    -951,
    -893,
    -836,
    -778,
    -721,
    -664,
    -608,
    -551,
    -495,
    -439,
    -383,
    -327,
    -272,
    -217,
    -162,
    -107,
    -53,
    0,
    54,
    107,
    160,
    213,
    266,
    318,
    370,
    422,
    473,
    524,
    574,
    625,
    675,
    724,
    773,
    822,
    870,
    918,
    966,
    1013,
    1060,
    1107,
    1153,
    1198,
    1243,
    1288,
    1332,
    1376,
    1420,
    1463,
    1505,
    1547,
    1589,
    1630,
    1671,
    1711,
    1751,
    1790,
    1829,
    1868,
    1906,
    1943,
    1980,
    2016,
    2052,
    2088,
    2123,
    2157,
    2191,
    2224,
    2257,
    2289,
    2321,
    2353,
    2383,
    2414,
    2444,
    2473,
    2501,
    2530,
    2557,
    2584,
    2611,
    2637,
    2663,
    2687,
    2712,
    2736,
    2759,
    2782,
    2804,
    2826,
    2847,
    2868,
    2888,
    2907,
    2926,
    2945,
    2962,
    2980,
    2997,
    3013,
    3028,
    3044,
    3058,
    3072,
    3086,
    3099,
    3111,
    3123,
    3134,
    3145,
    3155,
    3165,
    3174,
    3183,
    3191,
    3199,
    3206,
    3212,
    3218,
    3224,
    3228,
    3233,
    3237,
    3240,
    3243,
    3245,
    3247,
    3248,
    3249,
    3249,
    3249,
    3248,
    3247,
    3245,
    3243,
    3241,
    3237,
    3234,
    3229,
    3225,
    3220,
    3214,
    3208,
    3201,
    3194,
    3187,
    3179,
    3171,
    3162,
    3152,
    3143,
    3133,
    3122,
    3111,
    3099,
    3088,
    3075,
    3063,
    3049,
    3036,
    3022,
    3007,
    2993,
    2978,
    2962,
    2946,
    2930,
    2913,
    2896,
    2879,
    2861,
    2843,
    2824,
    2805,
    2786,
    2767,
    2747,
    2726,
    2706,
    2685,
    2664,
    2642,
    2621,
    2599,
    2576,
    2553,
    2530,
    2507,
    2484,
    2460,
    2436,
    2411,
    2387,
    2362,
    2337,
    2312,
    2286,
    2260,
    2234,
    2208,
    2181,
    2155,
    2128,
    2101,
    2073,
    2046,
    2018,
    1990,
    1962,
    1934,
    1906,
    1877,
    1848,
    1819,
    1790,
    1761,
    1732,
    1703,
    1673,
    1643,
    1614,
    1584,
    1554,
    1524,
    1493,
    1463,
    1433,
    1402,
    1372,
    1341,
    1311,
    1280,
    1249,
    1218,
    1187,
    1156,
    1126,
    1095,
    1064,
    1033,
    1002,
    971,
    940,
    908,
    877,
    846,
    815,
    784,
    753,
    722,
    692,
    661,
    630,
    599,
    568,
    538,
    507,
    477,
    446,
    416,
    385,
    355,
    325,
    295,
    265,
    235,
    205,
    176,
    146,
    117,
    87,
    58,
    29,
    0,
    -28,
    -56,
    -85,
    -113,
    -142,
    -170,
    -198,
    -225,
    -253,
    -280,
    -308,
    -335,
    -362,
    -388,
    -415,
    -441,
    -467,
    -493,
    -519,
    -545,
    -570,
    -595,
    -620,
    -645,
    -669,
    -693,
    -718,
    -741,
    -765,
    -788,
    -811,
    -834,
    -857,
    -880,
    -902,
    -924,
    -945,
    -967,
    -988,
    -1009,
    -1030,
    -1050,
    -1070,
    -1090,
    -1110,
    -1129,
    -1148,
    -1167,
    -1186,
    -1204,
    -1222,
    -1240,
    -1258,
    -1275,
    -1292,
    -1308,
    -1325,
    -1341,
    -1357,
    -1372,
    -1387,
    -1402,
    -1417,
    -1431,
    -1445,
    -1459,
    -1473,
    -1486,
    -1499,
    -1512,
    -1524,
    -1536,
    -1548,
    -1559,
    -1570,
    -1581,
    -1592,
    -1602,
    -1612,
    -1621,
    -1631,
    -1640,
    -1649,
    -1657,
    -1665,
    -1673,
    -1681,
    -1688,
    -1695,
    -1702,
    -1708,
    -1714,
    -1720,
    -1725,
    -1731,
    -1736,
    -1740,
    -1744,
    -1748,
    -1752,
    -1756,
    -1759,
    -1762,
    -1764,
    -1767,
    -1769,
    -1770,
    -1772,
    -1773,
    -1774,
    -1774,
    -1775,
    -1775,
    -1774,
    -1774,
    -1773,
    -1772,
    -1771,
    -1769,
    -1767,
    -1765,
    -1763,
    -1760,
    -1757,
    -1754,
    -1750,
    -1747,
    -1743,
    -1738,
    -1734,
    -1729,
    -1724,
    -1719,
    -1714,
    -1708,
    -1702,
    -1696,
    -1689,
    -1683,
    -1676,
    -1669,
    -1661,
    -1654,
    -1646,
    -1638,
    -1630,
    -1621,
    -1613,
    -1604,
    -1595,
    -1585,
    -1576,
    -1566,
    -1556,
    -1546,
    -1536,
    -1526,
    -1515,
    -1504,
    -1493,
    -1482,
    -1470,
    -1459,
    -1447,
    -1435,
    -1423,
    -1411,
    -1398,
    -1386,
    -1373,
    -1360,
    -1347,
    -1334,
    -1321,
    -1307,
    -1294,
    -1280,
    -1266,
    -1252,
    -1238,
    -1224,
    -1209,
    -1195,
    -1180,
    -1165,
    -1150,
    -1135,
    -1120,
    -1105,
    -1090,
    -1074,
    -1059,
    -1043,
    -1028,
    -1012,
    -996,
    -980,
    -964,
    -948,
    -932,
    -916,
    -900,
    -883,
    -867,
    -850,
    -834,
    -817,
    -801,
    -784,
    -767,
    -751,
    -734,
    -717,
    -700,
    -683,
    -666,
    -649,
    -632,
    -615,
    -599,
    -582,
    -565,
    -547,
    -530,
    -513,
    -496,
    -479,
    -462,
    -445,
    -428,
    -411,
    -394,
    -378,
    -361,
    -344,
    -327,
    -310,
    -293,
    -276,
    -260,
    -243,
    -226,
    -210,
    -193,
    -177,
    -160,
    -144,
    -128,
    -111,
    -95,
    -79,
    -63,
    -47,
    -31,
    -15,
    0,
    16,
    31,
    47,
    62,
    78,
    93,
    108,
    124,
    139,
    154,
    169,
    183,
    198,
    213,
    227,
    241,
    256,
    270,
    284,
    298,
    311,
    325,
    339,
    352,
    366,
    379,
    392,
    405,
    418,
    430,
    443,
    455,
    468,
    480,
    492,
    504,
    516,
    527,
    539,
    550,
    561,
    572,
    583,
    594,
    605,
    615,
    625,
    636,
    646,
    656,
    665,
    675,
    684,
    694,
    703,
    712,
    721,
    729,
    738,
    746,
    754,
    762,
    770,
    778,
    785,
    793,
    800,
    807,
    814,
    821,
    827,
    834,
    840,
    846,
    852,
    858,
    863,
    869,
    874,
    879,
    884,
    889,
    893,
    898,
    902,
    906,
    910,
    914,
    918,
    921,
    925,
    928,
    931,
    934,
    936,
    939,
    941,
    943,
    945,
    947,
    949,
    950,
    952,
    953,
    954,
    955,
    956,
    956,
    957,
    957,
    957,
    957,
    957,
    957,
    957,
    956,
    955,
    954,
    953,
    952,
    951,
    949,
    948,
    946,
    944,
    942,
    940,
    938,
    935,
    933,
    930,
    927,
    924,
    921,
    918,
    914,
    911,
    907,
    904,
    900,
    896,
    892,
    887,
    883,
    879,
    874,
    869,
    865,
    860,
    855,
    849,
    844,
    839,
    833,
    828,
    822,
    816,
    811,
    805,
    799,
    792,
    786,
    780,
    773,
    767,
    760,
    754,
    747,
    740,
    733,
    726,
    719,
    712,
    704,
    697,
    690,
    682,
    675,
    667,
    659,
    652,
    644,
    636,
    628,
    620,
    612,
    604,
    596,
    588,
    579,
    571,
    563,
    554,
    546,
    537,
    529,
    520,
    512,
    503,
    494,
    486,
    477,
    468,
    460,
    451,
    442,
    433,
    424,
    415,
    406,
    397,
    388,
    379,
    370,
    361,
    352,
    343,
    334,
    325,
    316,
    307,
    298,
    289,
    280,
    271,
    262,
    253,
    244,
    235,
    226,
    217,
    208,
    199,
    190,
    181,
    172,
    163,
    155,
    146,
    137,
    128,
    119,
    111,
    102,
    93,
    85,
    76,
    67,
    59,
    50,
    42,
    33,
    25,
    17,
    8,
    0,
    -7,
    -15,
    -24,
    -32,
    -40,
    -48,
    -56,
    -63,
    -71,
    -79,
    -87,
    -95,
    -102,
    -110,
    -117,
    -125,
    -132,
    -139,
    -147,
    -154,
    -161,
    -168,
    -175,
    -182,
    -189,
    -196,
    -202,
    -209,
    -216,
    -222,
    -229,
    -235,
    -241,
    -248,
    -254,
    -260,
    -266,
    -272,
    -278,
    -283,
    -289,
    -295,
    -300,
    -306,
    -311,
    -317,
    -322,
    -327,
    -332,
    -337,
    -342,
    -347,
    -352,
    -356,
    -361,
    -365,
    -370,
    -374,
    -378,
    -383,
    -387,
    -391,
    -395,
    -398,
    -402,
    -406,
    -409,
    -413,
    -416,
    -420,
    -423,
    -426,
    -429,
    -432,
    -435,
    -438,
    -441,
    -443,
    -446,
    -448,
    -451,
    -453,
    -455,
    -457,
    -459,
    -461,
    -463,
    -465,
    -467,
    -468,
    -470,
    -471,
    -473,
    -474,
    -475,
    -476,
    -477,
    -478,
    -479,
    -480,
    -481,
    -481,
    -482,
    -482,
    -483,
    -483,
    -483,
    -483,
    -483,
    -483,
    -483,
    -483,
    -483,
    -483,
    -482,
    -482,
    -481,
    -481,
    -480,
    -479,
    -478,
    -478,
    -477,
    -476,
    -474,
    -473,
    -472,
    -471,
    -469,
    -468,
    -466,
    -465,
    -463,
    -461,
    -460,
    -458,
    -456,
    -454,
    -452,
    -450,
    -448,
    -445,
    -443,
    -441,
    -438,
    -436,
    -433,
    -431,
    -428,
    -426,
    -423,
    -420,
    -417,
    -414,
    -412,
    -409,
    -406,
    -402,
    -399,
    -396,
    -393,
    -390,
    -386,
    -383,
    -380,
    -376,
    -373,
    -369,
    -366,
    -362,
    -359,
    -355,
    -351,
    -348,
    -344,
    -340,
    -336,
    -332,
    -329,
    -325,
    -321,
    -317,
    -313,
    -309,
    -305,
    -301,
    -296,
    -292,
    -288,
    -284,
    -280,
    -276,
    -271,
    -267,
    -263,
    -259,
    -254,
    -250,
    -246,
    -241,
    -237,
    -233,
    -228,
    -224,
    -219,
    -215,
    -211,
    -206,
    -202,
    -197,
    -193,
    -188,
    -184,
    -180,
    -175,
    -171,
    -166,
    -162,
    -157,
    -153,
    -148,
    -144,
    -139,
    -135,
    -131,
    -126,
    -122,
    -117,
    -113,
    -108,
    -104,
    -100,
    -95,
    -91,
    -87,
    -82,
    -78,
    -74,
    -69,
    -65,
    -61,
    -56,
    -52,
    -48,
    -44,
    -40,
    -36,
    -31,
    -27,
    -23,
    -19,
    -15,
    -11,
    -7,
    -3,
    0,
    4,
    8,
    12,
    16,
    19,
    23,
    27,
    31,
    35,
    38,
    42,
    46,
    49,
    53,
    56,
    60,
    63,
    67,
    70,
    74,
    77,
    80,
    83,
    87,
    90,
    93,
    96,
    99,
    102,
    106,
    109,
    112,
    114,
    117,
    120,
    123,
    126,
    129,
    131,
    134,
    137,
    139,
    142,
    144,
    147,
    149,
    151,
    154,
    156,
    158,
    161,
    163,
    165,
    167,
    169,
    171,
    173,
    175,
    177,
    179,
    181,
    183,
    184,
    186,
    188,
    189,
    191,
    192,
    194,
    195,
    197,
    198,
    199,
    201,
    202,
    203,
    204,
    205,
    207,
    208,
    209,
    210,
    210,
    211,
    212,
    213,
    214,
    215,
    215,
    216,
    216,
    217,
    218,
    218,
    218,
    219,
    219,
    220,
    220,
    220,
    220,
    221,
    221,
    221,
    221,
    221,
    221,
    221,
    221,
    221,
    220,
    220,
    220,
    220,
    220,
    219,
    219,
    218,
    218,
    218,
    217,
    217,
    216,
    215,
    215,
    214,
    214,
    213,
    212,
    211,
    211,
    210,
    209,
    208,
    207,
    206,
    205,
    204,
    203,
    202,
    201,
    200,
    199,
    198,
    197,
    195,
    194,
    193,
    192,
    190,
    189,
    188,
    186,
    185,
    184,
    182,
    181,
    179,
    178,
    176,
    175,
    173,
    172,
    170,
    169,
    167,
    165,
    164,
    162,
    160,
    159,
    157,
    155,
    154,
    152,
    150,
    148,
    147,
    145,
    143,
    141,
    139,
    137,
    136,
    134,
    132,
    130,
    128,
    126,
    124,
    123,
    121,
    119,
    117,
    115,
    113,
    111,
    109,
    107,
    105,
    103,
    101,
    99,
    97,
    95,
    93,
    91,
    90,
    88,
    86,
    84,
    82,
    80,
    78,
    76,
    74,
    72,
    70,
    68,
    66,
    64,
    62,
    60,
    58,
    56,
    54,
    52,
    50,
    49,
    47,
    45,
    43,
    41,
    39,
    37,
    35,
    34,
    32,
    30,
    28,
    26,
    24,
    23,
    21,
    19,
    17,
    15,
    14,
    12,
    10,
    8,
    7,
    5,
    3,
    2,
    0,
    -1,
    -2,
    -4,
    -6,
    -7,
    -9,
    -10,
    -12,
    -13,
    -15,
    -16,
    -18,
    -19,
    -21,
    -22,
    -24,
    -25,
    -27,
    -28,
    -29,
    -31,
    -32,
    -34,
    -35,
    -36,
    -37,
    -39,
    -40,
    -41,
    -42,
    -44,
    -45,
    -46,
    -47,
    -48,
    -49,
    -51,
    -52,
    -53,
    -54,
    -55,
    -56,
    -57,
    -58,
    -59,
    -60,
    -61,
    -62,
    -62,
    -63,
    -64,
    -65,
    -66,
    -67,
    -67,
    -68,
    -69,
    -70,
    -70,
    -71,
    -72,
    -73,
    -73,
    -74,
    -74,
    -75,
    -76,
    -76,
    -77,
    -77,
    -78,
    -78,
    -79,
    -79,
    -80,
    -80,
    -80,
    -81,
    -81,
    -82,
    -82,
    -82,
    -83,
    -83,
    -83,
    -83,
    -84,
    -84,
    -84,
    -84,
    -84,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -85,
    -84,
    -84,
    -84,
    -84,
    -84,
    -83,
    -83,
    -83,
    -83,
    -83,
    -82,
    -82,
    -82,
    -81,
    -81,
    -81,
    -80,
    -80,
    -80,
    -79,
    -79,
    -78,
    -78,
    -78,
    -77,
    -77,
    -76,
    -76,
    -75,
    -75,
    -74,
    -74,
    -73,
    -73,
    -72,
    -72,
    -71,
    -71,
    -70,
    -70,
    -69,
    -69,
    -68,
    -67,
    -67,
    -66,
    -66,
    -65,
    -64,
    -64,
    -63,
    -62,
    -62,
    -61,
    -60,
    -60,
    -59,
    -58,
    -58,
    -57,
    -56,
    -56,
    -55,
    -54,
    -54,
    -53,
    -52,
    -52,
    -51,
    -50,
    -49,
    -49,
    -48,
    -47,
    -47,
    -46,
    -45,
    -44,
    -44,
    -43,
    -42,
    -41,
    -41,
    -40,
    -39,
    -38,
    -38,
    -37,
    -36,
    -36,
    -35,
    -34,
    -33,
    -33,
    -32,
    -31,
    -30,
    -30,
    -29,
    -28,
    -27,
    -27,
    -26,
    -25,
    -25,
    -24,
    -23,
    -22,
    -22,
    -21,
    -20,
    -20,
    -19,
    -18,
    -17,
    -17,
    -16,
    -15,
    -15,
    -14,
    -13,
    -13,
    -12,
    -11,
    -11,
    -10,
    -9,
    -9,
    -8,
    -7,
    -7,
    -6,
    -6,
    -5,
    -4,
    -4,
    -3,
    -3,
    -2,
    -1,
    -1,
    0,
    0,
    0,
    1,
    1,
    2,
    2,
    3,
    3,
    4,
    4,
    5,
    5,
    6,
    6,
    7,
    7,
    8,
    8,
    9,
    9,
    10,
    10,
    11,
    11,
    12,
    12,
    12,
    13,
    13,
    14,
    14,
    14,
    15,
    15,
    16,
    16,
    16,
    17,
    17,
    17,
    18,
    18,
    18,
    19,
    19,
    19,
    20,
    20,
    20,
    20,
    21,
    21,
    21,
    21,
    22,
    22,
    22,
    22,
    23,
    23,
    23,
    23,
    23,
    24,
    24,
    24,
    24,
    24,
    24,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    22,
    22,
    22,
    22,
    22,
    22,
    21,
    21,
    21,
    21,
    21,
    20,
    20,
    20,
    20,
    20,
    19,
    19,
    19,
    19,
    19,
    18,
    18,
    18,
    18,
    18,
    17,
    17,
    17,
    17,
    17,
    16,
    16,
    16,
    16,
    16,
    15,
    15,
    15,
    15,
    14,
    14,
    14,
    14,
    14,
    13,
    13,
    13,
    13,
    12,
    12,
    12,
    12,
    12,
    11,
    11,
    11,
    11,
    11,
    10,
    10,
    10,
    10,
    9,
    9,
    9,
    9,
    9,
    8,
    8,
    8,
    8,
    8,
    7,
    7,
    7,
    7,
    7,
    6,
    6,
    6,
    6,
    6,
    5,
    5,
    5,
    5,
    5,
    5,
    4,
    4,
    4,
    4,
    4,
    3,
    3,
    3,
    3,
    3,
    3,
    2,
    2,
    2,
    2,
    2,
    2,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -4,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -3,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -2,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0 };
