﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include "../common/audio_Command.h"

#ifdef _NX_AUDIO_DSP_
#include <os/arch/cache.h>
#else
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_TickTypes.h>
#endif

#if defined(_NX_AUDIO_DSP_)
#define ADSP_HARDWARE_SELECT(adsp, cpu) adsp
#else
#define ADSP_HARDWARE_SELECT(adsp, cpu) cpu
#endif

namespace nn { namespace audio { namespace dsp {

namespace
{
typedef ADSP_HARDWARE_SELECT(lk_bigtime_t, nn::TimeSpan) Time;
} // anonymous namespace

class CommandListProcessor
{
protected:
    const void* m_pCommandList;
    const uint8_t* m_pCurrentCommand;
    size_t m_CommandListSize;
    uint32_t m_ProcessTimeMax;

    int32_t m_CommandCount;
    int32_t m_SampleCount;
    int32_t m_TargetSampleRate;
    int32_t* m_pMixBuffers;
    int32_t m_BufferCount;
    int32_t m_ProcessedCommandCount;
    Time m_StartTime;
    Time m_SkipTime;
    Time m_EndTime;

    NN_FORCEINLINE
    void ProcessCommand(const PcmInt16DataSourceCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const AdpcmDataSourceCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const OpusDataSourceCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const VolumeCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const VolumeRampCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const BiquadFilterCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const MixCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const MixRampCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const MixRampGroupedCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const DepopPrepareCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const DepopForMixBuffersCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const DelayCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const UpsampleCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const DownMix6chTo2chCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const AuxCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const DeviceSinkCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const ReverbCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const I3dl2ReverbCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const PerformanceCommand* pCommand, Time startTime) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const CircularBufferSinkCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const ClearMixBufferCommand* pCommand) NN_NOEXCEPT;
    NN_FORCEINLINE
    void ProcessCommand(const CopyMixBufferCommand* pCommand) NN_NOEXCEPT;
public:
    void Setup(const void* pCommandList, size_t commandListSize) NN_NOEXCEPT;
    uint64_t Process() NN_NOEXCEPT;
    void SetProcessTimeMax(uint32_t processTimeMax) NN_NOEXCEPT;
    int32_t GetCommandCount() const NN_NOEXCEPT;
    int32_t GetSampleCount() const NN_NOEXCEPT;
    int32_t GetTargetSampleRate() const NN_NOEXCEPT;
    int32_t* GetMixBuffers() const NN_NOEXCEPT;
    int32_t GetBufferCount() const NN_NOEXCEPT;
    int32_t GetProcessedCommandCount() const NN_NOEXCEPT;
    int32_t GetRemainCommandCount() const NN_NOEXCEPT;
};

}}}  // namespace nn::audio::dsp
