﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_BitUtil.h>
#include "audio_WorkBufferAllocator.h"

namespace nn { namespace audio { namespace common {

WorkBufferAllocator::WorkBufferAllocator(void* buffer, size_t size) NN_NOEXCEPT
    : m_Buffer(reinterpret_cast<uintptr_t>(buffer))
    , m_Size(size)
    , m_Offset(0)
{

}

void* WorkBufferAllocator::Allocate(size_t size, size_t align) NN_NOEXCEPT
{
    NN_SDK_ASSERT(align > 0);

    if(size == 0)
    {
        return nullptr;
    }

    const auto address = nn::util::align_up(m_Buffer + m_Offset, align);

    if (address + size > m_Buffer + m_Size)
    {
        return nullptr;
    }

    m_Offset += address - (m_Buffer + m_Offset) + size;

    return reinterpret_cast<void*>(address);
}

}}} // namespace nn::audio::common
