﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <limits> // std::numeric_limits
#include <cstdint> // std::uint32_t, std::uint64_t

#include <nn/nn_Macro.h>
#if defined(NN_BUILD_CONFIG_ADDRESS_32) && !defined(_NX_AUDIO_DSP_)
#include <nn/nn_SdkAssert.h>
#endif

#include "common/audio_BuildDefinition.h"

namespace nn {
namespace audio {

#if NN_AUDIO_DSP_ADDR_SIZE == 8
typedef uint64_t DspAddr;
#elif NN_AUDIO_DSP_ADDR_SIZE == 4
typedef uint32_t DspAddr;
#endif

struct CpuAddr
{
private:
    uint64_t m_Address;
public:
    NN_IMPLICIT CpuAddr(const void* rawPointer = nullptr) NN_NOEXCEPT
        : m_Address(reinterpret_cast<uintptr_t>(rawPointer))
    {

    }

    NN_IMPLICIT CpuAddr(uint64_t address) NN_NOEXCEPT
        : m_Address(address)
    {

    }

    void* GetPointer() const NN_NOEXCEPT
    {
#if defined(NN_BUILD_CONFIG_ADDRESS_32) && !defined(_NX_AUDIO_DSP_)
        NN_SDK_ASSERT(m_Address <= std::numeric_limits<uint32_t>::max());
#endif
        return reinterpret_cast<void*>(m_Address);
    }

    uint64_t GetAddress() const NN_NOEXCEPT
    {
        return m_Address;
    }

    bool IsNullPtr() const NN_NOEXCEPT
    {
        return m_Address == 0;
    }

    bool operator==(const CpuAddr& rhs) const
    {
        return (this->m_Address == rhs.m_Address);
    }
    bool operator!=(const CpuAddr& rhs) const
    {
        return !operator==(rhs);
    }
};

}  // namespace audio
}  // namespace nn
