﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/arp/detail/arp_LogUtil.h>

#include <nn/nn_SdkLog.h>
#include <nn/util/util_FormatString.h>

namespace nn {
namespace arp {
namespace detail {

namespace {

const char* GetStorageIdStr(const ncm::StorageId& storageId) NN_NOEXCEPT
{
    switch (storageId)
    {
    case ncm::StorageId::BuildInSystem:
        return "BuildInSystem";
    case ncm::StorageId::BuildInUser:
        return "BuildInUser";
    case ncm::StorageId::Card:
        return "Card";
    case ncm::StorageId::Host:
        return "Host";
    case ncm::StorageId::None:
        return "None";
    case ncm::StorageId::SdCard:
        return "SdCard";
    default:
        return "(unknown)";
    }
}

} // ~namespace nn::arp::detail::<anonymous>

void LogRegistration(const os::ProcessId& pid, const ApplicationLaunchProperty& launchProp, const ns::ApplicationControlProperty& ctrlProp) NN_NOEXCEPT
{
#if !defined(NN_SDK_BUILD_RELEASE)
    char launchPropStr[256];
    ApplicationLaunchPropertyToString(launchPropStr, sizeof(launchPropStr), launchProp);

    char ctrlPropStr[128];
    ApplicationControlPropertyToString(ctrlPropStr, sizeof(ctrlPropStr), ctrlProp);

    NN_SDK_LOG("[nn::arp] Registered for Pid=0x%016llx: %s (%s)\n", pid.value, launchPropStr, ctrlPropStr);
#else
    NN_UNUSED(pid);
    NN_UNUSED(launchProp);
    NN_UNUSED(ctrlProp);
#endif
}

int ApplicationLaunchPropertyToString(char* buffer, size_t bufferSize, const ApplicationLaunchProperty& launchProp) NN_NOEXCEPT
{
    auto l = util::SNPrintf(
        buffer, bufferSize, "Id=0x%016llx,Version=0x%08x,Storage=%s,PatchStorage=%s",
        launchProp.id.value, launchProp.version, GetStorageIdStr(launchProp.storageId), GetStorageIdStr(launchProp.patchStorageId));
    NN_SDK_ASSERT(static_cast<size_t>(l) < bufferSize);
    buffer[bufferSize - 1] = '\0';
    return l;
}
int ApplicationControlPropertyToString(char* buffer, size_t bufferSize, const ns::ApplicationControlProperty& launchProp) NN_NOEXCEPT
{
    auto l = util::SNPrintf(
        buffer, bufferSize, "DisplayVersion=\"%.*s\"",
        sizeof(launchProp.displayVersion), launchProp.displayVersion);
    NN_SDK_ASSERT(static_cast<size_t>(l) < bufferSize);
    buffer[bufferSize - 1] = '\0';
    return l;
}

} // ~namespace nn::arp::detail
}
}
