﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/arp/arp_Api.h>
#include <nn/arp/arp_Types.h>

#include <cstring>

#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn {
namespace arp {

// API ------------------------------------------------------------

Result AcquireRegistrar(Registrar* pRegistrar) NN_NOEXCEPT
{
    *pRegistrar = Registrar();
    NN_RESULT_SUCCESS;
}

void DeleteProperties(const os::ProcessId&) NN_NOEXCEPT
{
}

Result GetApplicationLaunchProperty(ApplicationLaunchProperty* pOut, const os::ProcessId&) NN_NOEXCEPT
{
    std::memset(pOut, 0x00, sizeof(*pOut));
    NN_RESULT_SUCCESS;
}

Result GetApplicationControlProperty(ns::ApplicationControlProperty* pOut, const os::ProcessId&) NN_NOEXCEPT
{
    std::memset(pOut, 0x00, sizeof(*pOut));
    NN_RESULT_SUCCESS;
}

// Registrar ------------------------------------------------------------

Registrar::Registrar(detail::IRegistrar*) NN_NOEXCEPT
    : m_Ptr(nullptr)
{
}
Registrar::Registrar() NN_NOEXCEPT
    : m_Ptr(nullptr)
{
}
Registrar::Registrar(Registrar&& rhs) NN_NOEXCEPT
    : m_Ptr(rhs.m_Ptr)
{
    rhs.m_Ptr = nullptr;
}
Registrar::~Registrar() NN_NOEXCEPT
{
    if (m_Ptr != nullptr)
    {
        Release();
    }
}
Registrar& Registrar::operator=(Registrar&& rhs) NN_NOEXCEPT
{
    Registrar tmp(std::move(rhs));
    std::swap(this->m_Ptr, tmp.m_Ptr);
    return *this;
}
void Registrar::Release() NN_NOEXCEPT
{
    m_Ptr = nullptr;
}
Result Registrar::SetApplicationLaunchProperty(const ApplicationLaunchProperty&) NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}
Result Registrar::SetApplicationControlProperty(const ns::ApplicationControlProperty&) NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}
Result Registrar::Issue(const os::ProcessId&) NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

}} // ~namespace nn::arp
