﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/applet/applet_LibraryAppletSelf.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <utility>
#include <nn/am/am_Result.h>
#include <nn/am/am_Shim.h>
#include <nn/applet/applet_Storage.h>
#include "applet_StorageUtility.h"

namespace nn { namespace applet {

using detail::GetShared;

void PushToSystemGeneralChannel(StorageHandle storageHandle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->PushToGeneralChannel(GetShared(storageHandle)));
    ReleaseStorage(storageHandle);
}

void BeginVrModeInternal() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->SetVrModeEnabled(true));
}

void EndVrModeInternal() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->SetVrModeEnabled(false));
}

}}
