﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/aoc.h>
#include <nn/aoc/detail/aoc_Service.h>
#include <nn/aocsrv/detail/aocsrv_IAddOnContentManager.sfdl.h>
#include <nn/aocsrv/detail/aocsrv_AddOnContentServiceName.h>
#include <nn/os/os_Mutex.h>

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/nn_SdkLog.h>


#if defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN)
#include <nn/aocsrv/detail/aocsrv_AddOnContentManagerImpl.h>
#endif

#include <mutex>


namespace nn { namespace aoc { namespace detail {
    namespace {
        typedef void(*HolderInitializer)(sf::ShimLibraryObjectHolder<nn::aocsrv::detail::IAddOnContentManager>&);

#if defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN)
        nn::sf::UnmanagedServiceObject<nn::aocsrv::detail::IAddOnContentManager, nn::aocsrv::detail::AddOnContentManagerImpl> g_ServiceObject;
        void InitializeHolderByDfc(sf::ShimLibraryObjectHolder<nn::aocsrv::detail::IAddOnContentManager>& holder)
        {
            holder.InitializeHolderDirectly(g_ServiceObject.GetShared());
        }
#endif

        sf::SimpleAllInOneHipcClientManager<17> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER;
        sf::ShimLibraryObjectHolder<nn::aocsrv::detail::IAddOnContentManager> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
        bool g_Initialized = false;

        void InitializeHolderByHipc(sf::ShimLibraryObjectHolder<nn::aocsrv::detail::IAddOnContentManager>& holder)
        {
            auto result = g_Manager.InitializeShimLibraryHolder(&holder, nn::aocsrv::detail::AocServiceName);
            if (result.IsSuccess()) {
                g_Initialized = true;
            }
            if (result.IsFailure())
            {
                NN_SDK_LOG("[aoc]: Initialize failed.(%08x)\n", result.GetInnerValueForDebug());
            }
        }

        void Initialize(HolderInitializer holderInitializer)
        {
            (*holderInitializer)(g_Holder);
        }
    }

#if defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN)
    void InitializeForDfc() NN_NOEXCEPT
    {
        Initialize(InitializeHolderByDfc);
    }
#endif

    void InitializeForHipc() NN_NOEXCEPT
    {
        Initialize(InitializeHolderByHipc);
    }

    void Finalize() NN_NOEXCEPT
    {
        if (g_Initialized)
        {
            g_Holder.FinalizeHolder();
            g_Initialized = false;
        }
    }

    sf::ShimLibraryObjectHolder<nn::aocsrv::detail::IAddOnContentManager>& GetObjectHolder() NN_NOEXCEPT
    {
        return g_Holder;
    }
}}} // namespace nn::aoc::detail
