﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.am
{
    /// <summary>
    /// ライブラリアプレット属性
    /// </summary>
    /// <remarks>
    /// </remarks>
    [CppRefPath(Location.CommonTypesPath)]
    [LargeData(true)]
    [BufferTransferMode(BufferTransferMode.MapAlias)]
    [ExternalStruct(128, 8)]
    public struct AppletAttribute
    {
    }
}

namespace nn.am.service
{
    [CppRefPath(Location.UserAppletProxyServiceSfdlPath)]
    public interface IApplicationProxyService : IServiceObject
    {
        [MethodId(0)]
        Result OpenApplicationProxy(Out<IApplicationProxy> pOut, [ProcessId] Bit64 processId, NativeHandle processHandle);
    }

    [CppRefPath(Location.SystemAppletProxyServiceSfdlPath)]
    public interface IAllSystemAppletProxiesService : IServiceObject
    {
        [MethodId(100)]
        Result OpenSystemAppletProxy(Out<ISystemAppletProxy> pOut, [ProcessId] Bit64 processId, NativeHandle processHandle);

        [MethodId(200)]
        Result OpenLibraryAppletProxyOld(Out<ILibraryAppletProxy> pOut, [ProcessId] Bit64 processId, NativeHandle processHandle);

        [MethodId(201)]
        Result OpenLibraryAppletProxy(Out<ILibraryAppletProxy> pOut, [ProcessId] Bit64 processId, NativeHandle processHandle, AppletAttribute appletAttribute);

        [MethodId(300)]
        Result OpenOverlayAppletProxy(Out<IOverlayAppletProxy> pOut, [ProcessId] Bit64 processId, NativeHandle processHandle);

        [MethodId(350)]
        Result OpenSystemApplicationProxy(Out<IApplicationProxy> pOut, [ProcessId] Bit64 processId, NativeHandle processHandle);

        [MethodId(400)]
        Result CreateSelfLibraryAppletCreatorForDevelop(Out<ILibraryAppletCreator> pOut, [ProcessId] Bit64 processId);

        [MethodId(410)]
        Result GetSystemAppletControllerForDebug(Out<ISystemAppletControllerForDebug> pOut);
    }
}
