﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/window/am_DisplayWindowController.h>

#include <nn/am/service/window/am_WindowSystem.h>

namespace nn { namespace am { namespace service { namespace window {

void DisplayWindowController::UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (oldStatus.IsVisible() && !newStatus.IsVisible())
    {
        p->GetTransiter()->SetGamePlayRecordingVisibility(false);
        p->GetTransiter()->SetDisplayVisibility(newStatus.IsVisible(), newStatus.zOrder, newStatus.staysDisplayOnInvisible);
    }
    else if (oldStatus.IsVisible() && newStatus.IsVisible() && oldStatus.zOrder > newStatus.zOrder)
    {
        p->GetTransiter()->SetGamePlayRecordingVisibility(false);
        p->GetTransiter()->SetDisplayVisibility(true, newStatus.zOrder, false);
    }

    // VR モード関連
    if (!oldStatus.needsRequestVrModeCurtain && newStatus.needsRequestVrModeCurtain)
    {
        p->GetTransiter()->OnVrModeCurtainRequired();
    }
    if (oldStatus.isVrMode != newStatus.isVrMode)
    {
        p->GetTransiter()->OnVrModeChanged(newStatus.isVrMode, newStatus.isVrModeChangedByApplication);
    }

    // LCD バックライト点灯（通常状態に戻す）
    if (oldStatus.isLcdBacklightOff && !newStatus.isLcdBacklightOff)
    {
        p->GetTransiter()->OnLcdBacklightChanged(false);
    }
    if (!oldStatus.needsSwitchLcdBacklightOnByForce && newStatus.needsSwitchLcdBacklightOnByForce)
    {
        p->GetTransiter()->SwitchLcdBacklightOnByForce();
    }
}

void DisplayWindowController::UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (!oldStatus.IsRequestedToDisplay() && newStatus.IsRequestedToDisplay())
    {
        p->GetTransiter()->RequestToDisplay(newStatus.clockOnRequestToDisplay);
    }
    if (!oldStatus.IsVisible() && newStatus.IsVisible())
    {
        p->GetTransiter()->SetDisplayVisibility(newStatus.IsVisible(), newStatus.zOrder, false);
        p->GetTransiter()->SetGamePlayRecordingVisibility(true);
    }
    else if (oldStatus.IsVisible() && newStatus.IsVisible() && oldStatus.zOrder < newStatus.zOrder)
    {
        p->GetTransiter()->SetDisplayVisibility(true, newStatus.zOrder, false);
        p->GetTransiter()->SetGamePlayRecordingVisibility(true);
    }

    // LCD バックライト消去（特殊状態にする）
    if (!oldStatus.isLcdBacklightOff && newStatus.isLcdBacklightOff)
    {
        p->GetTransiter()->OnLcdBacklightChanged(true);
    }
}

}}}}
