﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/window/am_AudioWindowController.h>

#include <nn/am/service/window/am_WindowSystem.h>

namespace nn { namespace am { namespace service { namespace window {

void AudioWindowController::UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (!newStatus.isVolumeAvailable && oldStatus.isVolumeAvailable)
    {
        // when available -> not available
        // fallthrough
    }
    else if (newStatus.isVolumeAvailable && !oldStatus.isVolumeAvailable)
    {
        // when not available -> available
        // do in positive
        return;
    }
    else if (newStatus.effectiveVolume < oldStatus.effectiveVolume)
    {
        // fallthrough
    }
    else
    {
        // do in positive
        return;
    }
    p->GetTransiter()->SetEffectiveVolume(newStatus.isVolumeAvailable, newStatus.effectiveVolume);
}

void AudioWindowController::UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (!newStatus.isVolumeAvailable && oldStatus.isVolumeAvailable)
    {
        // when available -> not available
        // do in negative
        return;
    }
    else if (newStatus.isVolumeAvailable && !oldStatus.isVolumeAvailable)
    {
        // when not available -> available
        // fallthrough
    }
    else if (newStatus.effectiveVolume > oldStatus.effectiveVolume)
    {
        // fallthrough
    }
    else
    {
        // do in negative
        return;
    }
    p->GetTransiter()->SetEffectiveVolume(newStatus.isVolumeAvailable, newStatus.effectiveVolume);
}

}}}}
