﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/display/am_IntegratedDisplayParameter.h>
#include <nn/vi/fbshare/vi_SharedFrameBufferSize.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/am/service/display/am_DisplayControlConfig.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    IntegratedDisplayParameter IntegratedDisplayParameter::GetValueForPureSharingMode() NN_NOEXCEPT
    {
        IntegratedDisplayParameter param = {};
        param.indexForFullscreen = nn::vi::fbshare::SharedLayerTextureIndexList::GetInvalidValue();
        param.indexForPartial = nn::vi::fbshare::SharedLayerTextureIndexList::GetInvalidValue();

        param.isBufferShaingEnabled = true;

        param.lastForegroundBufferIndex  = 0;
        param.lastApplicationBufferIndex = 1;
        param.callerAppletBufferIndex    = 2;
        param.indexForFullscreen[0]      = 3;
        param.indexForFullscreen[1]      = 4;
        param.indexForPartial[0]         = 5;
        param.indexForPartial[1]         = 6;
        param.transitionBufferIndex      = 0;

        param.startupLogoBufferIndex     = 6; // ロゴの展開先を指定する。 0 番には元データが入っているので 0 以外を指定する。

        // SIGLO-77289, NXBTS-17017:
        // OMM が出画する際にはアプレットの出画を止めるので全画面用の共有バッファが使用可能。
        param.operationModeBufferIndex    = param.indexForFullscreen[0];

        // SIGLO-75629:
        // アプリが FG の場合はテアリング防止のために一旦共有バッファに書き込んだ後でコピーする。
        // アプリは必ず自前バッファを使うので Fullscreen 用共有バッファを経由する。
        param.copyrightTemporalBufferIndex = param.indexForFullscreen[0];

        // レイアウトを変更した場合は am_DisplayControlConfig.h の RequiredSystemSharedBufferStaticStorage の値も修正すること。
        int64_t offset = 0;
        int64_t size   = nn::vi::fbshare::SharedFrameBufferSize;
        param.layout.count = 7;
        for(int32_t i = 0; i < param.layout.count; i++)
        {
            param.layout.entries[i].width  = nn::vi::fbshare::SharedFrameBufferWidth;
            param.layout.entries[i].height = nn::vi::fbshare::SharedFrameBufferHeight;
            param.layout.entries[i].offset = offset;
            param.layout.entries[i].size   = size;
            offset += size;
        }

        param.indirectProducerFlipOffset = nn::TimeSpan::FromMicroSeconds(5000);
        param.sharedLayerDetachTimeout   = nn::TimeSpan::FromMilliSeconds(100);
        param.captureBufferTimeout       = nn::TimeSpan::FromMilliSeconds(300);
        return param;
    }

}}}}
