﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/am/service/am_AppletSystem.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/audio/audio_Debugger.h>

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------
//  ShellEvent 監視用クラス
//  NuiShell から通知されてくるイベントを監視し、
//  各種イベント内容に応じた処理を行なう。
//
class ShellEvent
{
public:
    explicit ShellEvent(AppletSystem*) NN_NOEXCEPT;
    ~ShellEvent() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_ShellEventHolder);
    }
    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_ShellEventHolder);
    }
    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder)
    {
        if (holder == &m_ShellEventHolder)
        {
            ProcessShellEvent();
            return true;
        }
        return false;
    }

private:
    void ProcessShellEvent() NN_NOEXCEPT;
    void SuspendAudioOnDebugging(os::ProcessId pid) NN_NOEXCEPT;
    void ResumeAudioOnDebugging(os::ProcessId pid) NN_NOEXCEPT;

private:
    AppletSystem*           m_pAppletSystem;
    os::SystemEvent         m_ShellEvent;
    os::MultiWaitHolderType m_ShellEventHolder;
};

//-----------------------------------------------------------------------------

}}} // namespace nn::am::service

