﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/am/service/am_AppletSystem.h>

namespace nn { namespace am { namespace service {

class GameCardEvent
{
public:

    explicit GameCardEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT;
    ~GameCardEvent() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_GameCardStateChangedEventHolder);
    }

    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_GameCardStateChangedEventHolder);
    }

    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder)
    {
        if (holder == &m_GameCardStateChangedEventHolder)
        {
            GameCardStateChangedEventHandler();
            return true;
        }
        return false;
    }

private:

    void GameCardStateChangedEventHandler() NN_NOEXCEPT;

    void NotifyGameCardStateChanged() NN_NOEXCEPT
    {
        m_pAppletSystem->GetWindowManager()->NotifyGameCardStateChanged();
    }

private:

    AppletSystem*               m_pAppletSystem;
    os::SystemEvent             m_GameCardStateChangedEvent;
    os::MultiWaitHolderType     m_GameCardStateChangedEventHolder;

};

//-----------------------------------------------------------------------------

}}} // namespace nn::am::service
