﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>

#include "am_GameCardEvent.h"

namespace nn { namespace am { namespace service {

GameCardEvent::GameCardEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT
      : m_pAppletSystem( pAppletSystem )
{
    ns::GetGameCardAttachmentEvent(&m_GameCardStateChangedEvent);
    os::InitializeMultiWaitHolder(&m_GameCardStateChangedEventHolder, m_GameCardStateChangedEvent.GetBase());
    m_GameCardStateChangedEventHolder.userData = reinterpret_cast<uintptr_t>(this);
}

GameCardEvent::~GameCardEvent() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder( &m_GameCardStateChangedEventHolder );
}


void GameCardEvent::GameCardStateChangedEventHandler() NN_NOEXCEPT
{
    if (!m_GameCardStateChangedEvent.TryWait())
    {
        return;
    }
    m_GameCardStateChangedEvent.Clear();
    NotifyGameCardStateChanged();
}

}}}
