﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/am_ContinuousRecording.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/am/service/am_ServiceDiagnostics.h>
#include <nn/am/service/am_StuckChecker.h>
#include <nn/ncm/ncm_ProgramId.h>

#include <algorithm>

namespace nn { namespace am { namespace service {

namespace {

const ncm::ProgramId g_BlackListForEarlyAdopters[] =
{
    {   0x0000000000000000ull,  },
};

}   // namespace

bool IsInBlackListOfContinuousRecordingEarlyAdopters(ncm::ProgramId id) NN_NOEXCEPT
{
    auto first = std::begin(g_BlackListForEarlyAdopters);
    auto last  = std::end(g_BlackListForEarlyAdopters);

    return std::find(first, last, id) != last;
}

}}}
