﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>
#include "ahid_HdrCreateClient.h"

namespace nn {
namespace ahid {
namespace hdr {

namespace{

struct CreateHdrClientByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateHdrClientByHipcTag> HdrAllocator;

class HdrAllocatorInitializer
{
public:

    HdrAllocatorInitializer() NN_NOEXCEPT
    {
        HdrAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_HdrAllocatorInitializer;

};

nn::sf::SharedPointer<ISession> CreateClientByHipc(const char* pServiceName) NN_NOEXCEPT
{
    nn::sf::SharedPointer<ISession> ret;
    auto result = nn::sf::CreateHipcProxyByName<ISession, HdrAllocator::Policy>(&ret, pServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}


}   // namespace hdr
}   // namespace ahid
}   // namespace nn
