﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/sf/sf_Types.h>
#include <nn/ahid/hdr/hdr.h>
#include "../libnn_hdrServer/ahid_HdrServiceName.h"
#include "ahid_HdrCreateClient.h"


namespace nn {
namespace ahid {
namespace hdr {

//////////////////////////////////////////////////////////////////////////////
//  public functions
//////////////////////////////////////////////////////////////////////////////
Result Hdr::Initialize() NN_NOEXCEPT
{
    NN_SDK_ASSERT(!m_Client);

    m_Client = CreateClientByHipc(HdrServiceName);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::InitializeWith(nn::sf::SharedPointer<nn::ahid::hdr::ISession> session) NN_NOEXCEPT
{
    NN_SDK_ASSERT(!m_Client);

    m_Client = session;

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::Finalize() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Client);

    nn::sf::ReleaseSharedObject(m_Client.Detach());

    m_Client = nullptr;

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::GetDeviceEntries(size_t* pEntries) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Client);

    return m_Client->GetDeviceEntries(reinterpret_cast<uint32_t*>(pEntries));
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::GetDeviceList(size_t* pOutEntries, size_t handleEntries, DeviceHandle* pHandles, AttachFilter* pFilter) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Client);

    nn::sf::OutBuffer outBuffer(reinterpret_cast<char*>(pHandles), sizeof(DeviceHandle) * handleEntries);
    nn::sf::InBuffer inBuffer(reinterpret_cast<char*>(pFilter), sizeof(AttachFilter));
    return m_Client->GetDeviceList(reinterpret_cast<uint32_t*>(pOutEntries), static_cast<int32_t>(handleEntries), outBuffer, inBuffer);
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::GetDeviceParameters(DeviceParameters* pParameters, DeviceHandle handle) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Client);

    nn::sf::OutBuffer buffer(reinterpret_cast<char*>(pParameters), sizeof(DeviceParameters));
    return m_Client->GetDeviceParameters(handle, buffer);
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::AttachDevice(DeviceHandle* pHandle, DeviceParameters* pParameters) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Client);

    nn::sf::InBuffer buffer(reinterpret_cast<char*>(pParameters), sizeof(DeviceParameters));
    return m_Client->AttachDevice(buffer, pHandle);
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::DetachDevice(DeviceHandle handle) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Client);

    return m_Client->DetachDevice(handle);
}


//////////////////////////////////////////////////////////////////////////////
Result Hdr::SetDeviceFilterForHipc(DeviceFilter *pDeviceFilter, size_t entries) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Client);

    nn::sf::InBuffer buffer(reinterpret_cast<char*>(pDeviceFilter), sizeof(DeviceFilter) * entries);

    return m_Client->SetDeviceFilterForHipc(buffer, static_cast<uint32_t>(entries));
}


} // end of namespace hdr
} // end of namespace ahid
} // end of namespace nn




