﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/json/account_JsonAdaptor.h>
#include <nn/account/account_Result.h>
#include <nn/account/account_TypesForSystemServices.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace account { namespace nas {

class NasOp2MembershipAdaptor final
{
    NN_DISALLOW_COPY(NasOp2MembershipAdaptor);

private:
    json::LookupEntry m_MembershipActiveEntry;
    json::LookupEntry m_MembershipExpiresAtEntry;

    bool m_Active;
    int64_t m_ExpirationAbs;

    bool m_IsAdapted;

public:
    typedef json::JsonPath<8, 32> JsonPathType;

public:
    NasOp2MembershipAdaptor() NN_NOEXCEPT;

    void GetMembership(NetworkServiceLicense* pOutLicense, time::PosixTime* pOutExpiration) NN_NOEXCEPT;

    Result Adapt(int32_t httpCode) NN_NOEXCEPT;

    void Update(const JsonPathType& jsonPath, bool value) NN_NOEXCEPT;
    void Update(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT;

    void Update(const JsonPathType&, const char*, int) NN_NOEXCEPT {} // NOP
    void Update(const JsonPathType&, std::nullptr_t) NN_NOEXCEPT {} // NOP
    void Update(const JsonPathType&, uint64_t) NN_NOEXCEPT {} // NOP
    void Update(const JsonPathType&, double) NN_NOEXCEPT {} // NOP
    void NotifyObjectBegin(const JsonPathType&) NN_NOEXCEPT {} // NOP
    void NotifyObjectEnd(const JsonPathType&) NN_NOEXCEPT {} // NOP
};

}}} // ~namespace nn::account::nas
