﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_InternalConfig.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/detail/account_LocalStorage.h>

#include <nn/nn_Result.h>

namespace nn { namespace account { namespace nas {

const char AuthorizationLead[] = "Authorization: Bearer ";
const size_t RequiredBufferSizeForAuthorizationHeader = sizeof(AuthorizationLead) + detail::NasAccessTokenSizeMax;

Result CreateAuthorizationHeader(char* buffer, size_t bufferSize, const detail::Uuid& accessTokenCacheId, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;

}}}
