﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Tick.h>

namespace nn { namespace account { namespace detail {

inline int64_t GetUptimeInSeconds() NN_NOEXCEPT
{
    return os::GetSystemTick().ToTimeSpan().GetSeconds();
}

template <int64_t value>
struct MilliSecond
{
    static const int64_t msec = value;
    static const int64_t sec = msec / 1000;
    static const int64_t min = sec / 60;
    static const int64_t hrs = min / 60;
};

template <int64_t value>
struct Second
    : public MilliSecond<value * 1000LL>
{
};

template <int64_t value>
struct Minute
    : public Second<value * 60LL>
{
};

template <int64_t value>
struct Hour
    : public Minute<value * 60LL>
{
};


}}} // ~namespace nn::account::detail
