﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <algorithm>
#include <nn/nn_Common.h>

namespace nn { namespace account { namespace detail {

// 配列をコピーしつつ、実際のコピー元配列の長さを返す
template <typename T>
inline int CopyList(T* dst, int dstLength, const T* src, int srcLength, const T Terminator) NN_NOEXCEPT
{
    int ct = 0;
    for (auto i = 0; i < srcLength && src[i] != Terminator; ++ i)
    {
        ct ++;
    }
    auto copyCount = std::min(dstLength, ct);
    for (auto i = 0; i < dstLength; ++ i)
    {
        dst[i] = (i < copyCount? src[i]: Terminator);
    }
    return ct;
}

}}} // ~namespace nn::account::detail
