﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "account_BaasProblemDetails.h"
#include <nn/account/baas/account_BaasLoginCache.h>
#include <nn/account/baas/account_BaasTypes.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/json/account_JsonAdaptor.h>
#include <nn/account/account_Result.h>

#include <cstddef>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace account { namespace baas {


// AA および DA を新規に取得するアダプタ
class DeviceAccountRegistrationAdaptor
    : public BaasCommonAdaptor<8, 32>
{
    NN_DISALLOW_COPY(DeviceAccountRegistrationAdaptor);
private:
    typedef BaasCommonAdaptor<8, 32> Base;

    json::LookupEntry m_UserIdEntry;
    json::LookupEntry m_LoginIdEntry;
    json::LookupEntry m_LoginPasswordEntry;

    NetworkServiceAccountId m_Id;
    BaasCredential m_Credential;
    bool m_IsAdapted;

public:
    typedef Base::JsonPathType JsonPathType;

protected:
    virtual Result AdaptImpl() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT NN_OVERRIDE;

public:
    DeviceAccountRegistrationAdaptor() NN_NOEXCEPT;
    NetworkServiceAccountId GetId() const NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_IsAdapted);
        return m_Id;
    }
    BaasCredential GetCredential() const NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_IsAdapted);
        return m_Credential;
    }
};

}}} // ~namespace nn::account::baas
