﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/baas/account_BaasUserDriver.h>
#include <nn/account/baas/account_BaasUserResourceCache.h>
#include <nn/account/profile/account_ProfileStorage.h>
#include <nn/account/account_RuntimeResource.h>

namespace nn {
namespace account {
namespace baas {

Result ExportBaasUserProfile(
    profile::ProfileStorage& profileStorage,
    BaasUserResourceCache& resourceCache,
    const Uid& user, const NetworkServiceAccountId& id,
    const BaasUserDriver& baasUserDriver, const detail::AbstractLocalStorage& storage,
    const ExecutionResource& resource, detail::Cancellable* pCancellable) NN_NOEXCEPT;

Result SynchronizeBaasUserProfile(
    profile::ProfileStorage& profileStorage,
    BaasUserResourceCache& resourceCache,
    const Uid& user, const NetworkServiceAccountId& id,
    const BaasUserDriver& baasUserDriver, const detail::AbstractLocalStorage& storage,
    const ExecutionResource& resource, detail::Cancellable* pCancellable) NN_NOEXCEPT;

Result SynchronizeBaasUserProfile(
    profile::ProfileStorage& profileStorage,
    BaasUserResourceCache& resourceCache,
    const Uid& user, const NetworkServiceAccountId& id, const UserProfile& profile,
    const BaasUserDriver& baasUserDriver, const detail::AbstractLocalStorage& storage,
    const ExecutionResource& resource, detail::Cancellable* pCancellable) NN_NOEXCEPT;

Result DownloadProfileImage(
    size_t* pOutActualSize, void* image, size_t imageSize,
    const char* url,
    const ExecutionResource& resource, detail::Cancellable* pCancellable) NN_NOEXCEPT;

} // ~namespace nn::accout::baas
}
}
